// MikroChat - See LICENSE file for copyright and license details.
import B,{createHash as qr,createHmac as Kr,scryptSync as it,randomBytes as at,createCipheriv as ot,createDecipheriv as ct}from"crypto";import{URL as lt}from"url";var ae=class extends Error{constructor(t){super(t),this.name="ValidationError",this.message=t||"Validation did not pass",this.cause={statusCode:400}}};import{existsSync as Xe,readFileSync as Ze}from"node:fs";var L=class{config={};options=[];validators=[];autoValidate=!0;constructor(t){let e=t?.configFilePath,r=t?.args||[],s=t?.config||{};this.options=t?.options||[],this.validators=t?.validators||[],t?.autoValidate!==void 0&&(this.autoValidate=t.autoValidate),this.config=this.createConfig(e,r,s)}deepMerge(t,e){let r={...t};for(let s in e)e[s]!==void 0&&(e[s]!==null&&typeof e[s]=="object"&&!Array.isArray(e[s])&&s in t&&t[s]!==null&&typeof t[s]=="object"&&!Array.isArray(t[s])?r[s]=this.deepMerge(t[s],e[s]):e[s]!==void 0&&(r[s]=e[s]));return r}setValueAtPath(t,e,r){let s=e.split("."),i=t;for(let o=0;o<s.length-1;o++){let h=s[o];!(h in i)||i[h]===null?i[h]={}:typeof i[h]!="object"&&(i[h]={}),i=i[h]}let a=s[s.length-1];i[a]=r}getValueAtPath(t,e){let r=e.split("."),s=t;for(let i of r){if(s==null)return;s=s[i]}return s}createConfig(t,e=[],r={}){let s={};for(let h of this.options)h.defaultValue!==void 0&&this.setValueAtPath(s,h.path,h.defaultValue);let i={};if(t&&Xe(t))try{let h=Ze(t,"utf8");i=JSON.parse(h),console.log(`Loaded configuration from ${t}`)}catch(h){console.error(`Error reading config file: ${h instanceof Error?h.message:String(h)}`)}let a=this.parseCliArgs(e),o=this.deepMerge({},s);return o=this.deepMerge(o,i),o=this.deepMerge(o,r),o=this.deepMerge(o,a),o}parseCliArgs(t){let e={},r=t[0]?.endsWith("node")||t[0]?.endsWith("node.exe")?2:0;for(;r<t.length;){let s=t[r++],i=this.options.find(a=>a.flag===s);if(i)if(i.isFlag)this.setValueAtPath(e,i.path,!0);else if(r<t.length&&!t[r].startsWith("-")){let a=t[r++];if(i.parser)try{a=i.parser(a)}catch(o){console.error(`Error parsing value for ${i.flag}: ${o instanceof Error?o.message:String(o)}`);continue}if(i.validator){let o=i.validator(a);if(o!==!0&&typeof o=="string"){console.error(`Invalid value for ${i.flag}: ${o}`);continue}if(o===!1){console.error(`Invalid value for ${i.flag}`);continue}}this.setValueAtPath(e,i.path,a)}else console.error(`Missing value for option ${s}`)}return e}validate(){for(let t of this.validators){let e=this.getValueAtPath(this.config,t.path),r=t.validator(e,this.config);if(r===!1)throw new ae(t.message);if(typeof r=="string")throw new ae(r)}}get(){return this.autoValidate&&this.validate(),this.config}getValue(t,e){let r=this.getValueAtPath(this.config,t);return r!==void 0?r:e}setValue(t,e){if(typeof e=="object"&&e!==null&&!Array.isArray(e)){let r=this.getValueAtPath(this.config,t)||{};if(typeof r=="object"&&!Array.isArray(r)){let s=this.deepMerge(r,e);this.setValueAtPath(this.config,t,s);return}}this.setValueAtPath(this.config,t,e)}getHelpText(){let t=`Available configuration options:

`;for(let e of this.options)t+=`${e.flag}${e.isFlag?"":" <value>"}
`,e.description&&(t+=`  ${e.description}
`),e.defaultValue!==void 0&&(t+=`  Default: ${JSON.stringify(e.defaultValue)}
`),t+=`
`;return t}};var D={int:t=>{let e=t.trim();if(!/^[+-]?\d+$/.test(e))throw new Error(`Cannot parse "${t}" as an integer`);let r=Number.parseInt(e,10);if(Number.isNaN(r))throw new Error(`Cannot parse "${t}" as an integer`);return r},float:t=>{let e=t.trim();if(!/^[+-]?(?:\d+(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+)?$/.test(e)){if(e==="Infinity"||e==="-Infinity")return e==="Infinity"?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY;throw new Error(`Cannot parse "${t}" as a number`)}let r=Number.parseFloat(e);if(Number.isNaN(r))throw new Error(`Cannot parse "${t}" as a number`);return r},boolean:t=>{let e=t.trim().toLowerCase();if(["true","yes","1","y"].includes(e))return!0;if(["false","no","0","n"].includes(e))return!1;throw new Error(`Cannot parse "${t}" as a boolean`)},array:t=>t.split(",").map(e=>e.trim()),json:t=>{try{return JSON.parse(t)}catch{throw new Error(`Cannot parse "${t}" as JSON`)}}};import{EventEmitter as ut}from"events";var Se=class extends Error{constructor(t){super(),this.name="ValidationError",this.message=t,this.cause={statusCode:400}}};import{existsSync as Qe,readFileSync as et}from"fs";var xe=class{config;defaults={configFilePath:"mikromail.config.json",args:[]};constructor(t){let e=t?.config||{},r=t?.configFilePath||this.defaults.configFilePath,s=t?.args||this.defaults.args;this.config=this.create(r,s,e)}create(t,e,r){let s={host:"",user:"",password:"",port:465,secure:!0,debug:!1,maxRetries:2,skipEmailValidation:!1,skipMXRecordCheck:!1},i={};if(Qe(t))try{let o=et(t,"utf8");i=JSON.parse(o),console.log(`Loaded configuration from ${t}`)}catch(o){console.error(`Error reading config file: ${o instanceof Error?o.message:String(o)}`)}let a=this.parseCliArgs(e);return{...s,...r,...i,...a}}parseCliArgs(t){let e={};for(let r=2;r<t.length;r++)switch(t[r]){case"--host":r+1<t.length&&(e.host=t[++r]);break;case"--user":r+1<t.length&&(e.user=t[++r]);break;case"--password":r+1<t.length&&(e.password=t[++r]);break;case"--port":if(r+1<t.length){let i=Number.parseInt(t[++r],10);Number.isNaN(i)||(e.port=i)}break;case"--secure":e.secure=!0;break;case"--debug":e.debug=!0;break;case"--retries":if(r+1<t.length){let i=Number.parseInt(t[++r],10);Number.isNaN(i)||(e.maxRetries=i)}break}return e}validate(){if(!this.config.host)throw new Se("Host value not found")}get(){return this.validate(),this.config}};import{promises as tt}from"dns";function W(t){try{let[e,r]=t.split("@");if(!e||e.length>64||e.startsWith(".")||e.endsWith(".")||e.includes("..")||!/^[a-zA-Z0-9!#$%&'*+\-/=?^_`{|}~.]+$/.test(e)||!r||r.length>255)return!1;if(r.startsWith("[")&&r.endsWith("]")){let i=r.slice(1,-1);return i.startsWith("IPv6:")?!0:/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/.test(i)}if(r.startsWith(".")||r.endsWith(".")||r.includes(".."))return!1;let s=r.split(".");if(s.length<2||s[s.length-1].length<2)return!1;for(let i of s)if(!i||i.length>63||!/^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$/.test(i))return!1;return!0}catch{return!1}}async function rt(t){try{let e=await tt.resolveMx(t);return!!e&&e.length>0}catch{return!1}}async function Te(t){try{let e=t.split("@")[1];return e?await rt(e):!1}catch{return!1}}import{Buffer as F}from"buffer";import oe from"crypto";import st from"net";import nt from"os";import Ae from"tls";var ke=class{config;socket;connected;lastCommand;serverCapabilities;secureMode;retryCount;maxEmailSize=10485760;constructor(t){this.config={host:t.host,user:t.user,password:t.password,port:t.port??(t.secure?465:587),secure:t.secure??!0,debug:t.debug??!1,timeout:t.timeout??1e4,clientName:t.clientName??nt.hostname(),maxRetries:t.maxRetries??3,retryDelay:t.retryDelay??1e3,skipAuthentication:t.skipAuthentication||!1,skipEmailValidation:t.skipEmailValidation||!1,skipMXRecordCheck:t.skipMXRecordCheck||!1},this.socket=null,this.connected=!1,this.lastCommand="",this.serverCapabilities=[],this.secureMode=this.config.secure,this.retryCount=0}log(t,e=!1){this.config.debug&&console.log(`${e?"SMTP ERROR: ":"SMTP: "}${t}`)}async connect(){return new Promise((t,e)=>{let r=setTimeout(()=>{e(new Error(`Connection timeout after ${this.config.timeout}ms`)),this.socket?.destroy()},this.config.timeout);try{this.config.secure?this.createTLSConnection(r,t,e):this.createPlainConnection(r,t,e)}catch(s){clearTimeout(r),this.log(`Failed to create socket: ${s.message}`,!0),e(s)}})}createTLSConnection(t,e,r){this.socket=Ae.connect({host:this.config.host,port:this.config.port,rejectUnauthorized:!0,minVersion:"TLSv1.2",ciphers:"HIGH:!aNULL:!MD5:!RC4"}),this.setupSocketEventHandlers(t,e,r)}createPlainConnection(t,e,r){this.socket=st.createConnection({host:this.config.host,port:this.config.port}),this.setupSocketEventHandlers(t,e,r)}setupSocketEventHandlers(t,e,r){this.socket&&(this.socket.once("error",s=>{clearTimeout(t),this.log(`Connection error: ${s.message}`,!0),r(new Error(`SMTP connection error: ${s.message}`))}),this.socket.once("connect",()=>{this.log("Connected to SMTP server"),clearTimeout(t),this.socket.once("data",s=>{let i=s.toString().trim();this.log(`Server greeting: ${i}`),i.startsWith("220")?(this.connected=!0,this.secureMode=this.config.secure,e()):(r(new Error(`Unexpected server greeting: ${i}`)),this.socket.destroy())})}),this.socket.once("close",s=>{this.connected?this.log(`Connection closed${s?" with error":""}`):(clearTimeout(t),r(new Error("Connection closed before initialization completed"))),this.connected=!1}))}async upgradeToTLS(){if(!(!this.socket||this.secureMode))return new Promise((t,e)=>{let s={socket:this.socket,host:this.config.host,rejectUnauthorized:!0,minVersion:"TLSv1.2",ciphers:"HIGH:!aNULL:!MD5:!RC4"},i=Ae.connect(s);i.once("error",a=>{this.log(`TLS upgrade error: ${a.message}`,!0),e(new Error(`STARTTLS error: ${a.message}`))}),i.once("secureConnect",()=>{this.log("Connection upgraded to TLS"),i.authorized?(this.socket=i,this.secureMode=!0,t()):e(new Error(`TLS certificate verification failed: ${i.authorizationError}`))})})}async sendCommand(t,e,r=this.config.timeout){if(!this.socket||!this.connected)throw new Error("Not connected to SMTP server");return new Promise((s,i)=>{let a=setTimeout(()=>{this.socket?.removeListener("data",h),i(new Error(`Command timeout after ${r}ms: ${t}`))},r),o="",h=d=>{o+=d.toString();let y=o.split(`\r
`);if(y.length>0&&y[y.length-1]===""){let w=y[y.length-2]||"",f=/^(\d{3})(.?)/.exec(w);f?.[1]&&f[2]!=="-"&&(this.socket?.removeListener("data",h),clearTimeout(a),this.log(`SMTP Response: ${o.trim()}`),f[1]===e.toString()?s(o.trim()):i(new Error(`SMTP Error: ${o.trim()}`)))}};this.socket.on("data",h),t.startsWith("AUTH PLAIN")||t.startsWith("AUTH LOGIN")||this.lastCommand==="AUTH LOGIN"&&!t.startsWith("AUTH")?this.log("SMTP Command: [Credentials hidden]"):this.log(`SMTP Command: ${t}`),this.lastCommand=t,this.socket.write(`${t}\r
`)})}parseCapabilities(t){let e=t.split(`\r
`);this.serverCapabilities=[];for(let r=1;r<e.length;r++){let s=e[r];if(s.match(/^\d{3}/)&&s.charAt(3)===" "){let i=s.substr(4).toUpperCase();this.serverCapabilities.push(i)}}this.log(`Server capabilities: ${this.serverCapabilities.join(", ")}`)}getBestAuthMethod(){if(this.serverCapabilities.map(e=>e.split(" ")[0]).includes("AUTH")){let e=this.serverCapabilities.find(r=>r.startsWith("AUTH "));if(e){let r=e.split(" ").slice(1);if(r.includes("CRAM-MD5"))return"CRAM-MD5";if(r.includes("LOGIN"))return"LOGIN";if(r.includes("PLAIN"))return"PLAIN"}}return"PLAIN"}async authenticate(){switch(this.getBestAuthMethod()){case"CRAM-MD5":await this.authenticateCramMD5();break;case"LOGIN":await this.authenticateLogin();break;default:await this.authenticatePlain();break}}async authenticatePlain(){let t=F.from(`\0${this.config.user}\0${this.config.password}`).toString("base64");await this.sendCommand(`AUTH PLAIN ${t}`,235)}async authenticateLogin(){await this.sendCommand("AUTH LOGIN",334),await this.sendCommand(F.from(this.config.user).toString("base64"),334),await this.sendCommand(F.from(this.config.password).toString("base64"),235)}async authenticateCramMD5(){let t=await this.sendCommand("AUTH CRAM-MD5",334),e=F.from(t.substr(4),"base64").toString("utf8"),r=oe.createHmac("md5",this.config.password);r.update(e);let s=r.digest("hex"),i=`${this.config.user} ${s}`,a=F.from(i).toString("base64");await this.sendCommand(a,235)}generateMessageId(){let t=oe.randomBytes(16).toString("hex"),e=this.config.user.split("@")[1]||"localhost";return`<${t}@${e}>`}generateBoundary(){return`----=_NextPart_${oe.randomBytes(12).toString("hex")}`}encodeHeaderValue(t){return/^[\x00-\x7F]*$/.test(t)?t:`=?UTF-8?Q?${t.replace(/[^\x00-\x7F]/g,e=>{let r=e.charCodeAt(0).toString(16).toUpperCase();return`=${r.length<2?`0${r}`:r}`})}?=`}sanitizeHeader(t){let e=t.replace(/[\r\n\t]+/g," ").replace(/\s{2,}/g," ").trim();return this.encodeHeaderValue(e)}createEmailHeaders(t){let e=this.generateMessageId(),r=new Date().toUTCString(),s=t.from||this.config.user,i=Array.isArray(t.to)?t.to.join(", "):t.to,a=[`From: ${this.sanitizeHeader(s)}`,`To: ${this.sanitizeHeader(i)}`,`Subject: ${this.sanitizeHeader(t.subject)}`,`Message-ID: ${e}`,`Date: ${r}`,"MIME-Version: 1.0"];if(t.cc){let o=Array.isArray(t.cc)?t.cc.join(", "):t.cc;a.push(`Cc: ${this.sanitizeHeader(o)}`)}if(t.replyTo&&a.push(`Reply-To: ${this.sanitizeHeader(t.replyTo)}`),t.headers)for(let[o,h]of Object.entries(t.headers))/^[a-zA-Z0-9-]+$/.test(o)&&(/^(from|to|cc|bcc|subject|date|message-id)$/i.test(o)||a.push(`${o}: ${this.sanitizeHeader(h)}`));return a}createMultipartEmail(t){let{text:e,html:r}=t,s=this.createEmailHeaders(t),i=this.generateBoundary();return r&&e?(s.push(`Content-Type: multipart/alternative; boundary="${i}"`),`${s.join(`\r
`)}\r
\r
--${i}\r
Content-Type: text/plain; charset=utf-8\r
\r
${e||""}\r
\r
--${i}\r
Content-Type: text/html; charset=utf-8\r
\r
${r||""}\r
\r
--${i}--\r
`):(s.push("Content-Type: text/html; charset=utf-8"),r?`${s.join(`\r
`)}\r
\r
${r}`:`${s.join(`\r
`)}\r
\r
${e||""}`)}async smtpHandshake(){let t=await this.sendCommand(`EHLO ${this.config.clientName}`,250);if(this.parseCapabilities(t),!this.secureMode&&this.serverCapabilities.includes("STARTTLS")){await this.sendCommand("STARTTLS",220),await this.upgradeToTLS();let e=await this.sendCommand(`EHLO ${this.config.clientName}`,250);this.parseCapabilities(e)}this.config.skipAuthentication?this.log("Authentication skipped (testing mode)"):await this.authenticate()}async sendEmail(t){let e=t.from||this.config.user,{to:r,subject:s}=t,i=t.text||"",a=t.html||"";if(!e||!r||!s||!i&&!a)return{success:!1,error:"Missing required email parameters (from, to, subject, and either text or html)"};let o=Array.isArray(t.to)?t.to:[t.to];if(this.config.skipEmailValidation)this.log("Email validation skipped (testing mode)");else{if(!W(e))return{success:!1,error:"Invalid email address format"};for(let h of o)if(!W(h))return{success:!1,error:`Invalid recipient email address format: ${h}`}}for(this.retryCount=0;this.retryCount<=this.config.maxRetries;this.retryCount++)try{this.retryCount>0&&(this.log(`Retrying email send (attempt ${this.retryCount} of ${this.config.maxRetries})...`),await new Promise(w=>setTimeout(w,this.config.retryDelay))),this.connected||(await this.connect(),await this.smtpHandshake()),await this.sendCommand(`MAIL FROM:<${e}>`,250);for(let w of o)await this.sendCommand(`RCPT TO:<${w}>`,250);if(t.cc){let w=Array.isArray(t.cc)?t.cc:[t.cc];for(let f of w)W(f)&&await this.sendCommand(`RCPT TO:<${f}>`,250)}if(t.bcc){let w=Array.isArray(t.bcc)?t.bcc:[t.bcc];for(let f of w)W(f)&&await this.sendCommand(`RCPT TO:<${f}>`,250)}await this.sendCommand("DATA",354);let h=this.createMultipartEmail(t);if(h.length>this.maxEmailSize)return{success:!1,error:"Email size exceeds maximum allowed"};await this.sendCommand(`${h}\r
.`,250);let d=/Message-ID: (.*)/i.exec(h);return{success:!0,messageId:d?d[1].trim():void 0,message:"Email sent successfully"}}catch(h){let d=h.message;if(this.log(`Error sending email: ${d}`,!0),d.includes("5.")||d.includes("Authentication failed")||d.includes("certificate")||this.retryCount>=this.config.maxRetries)return{success:!1,error:d};try{this.connected&&await this.sendCommand("RSET",250)}catch{}this.socket?.end(),this.connected=!1}return{success:!1,error:"Maximum retry count exceeded"}}async close(){try{this.connected&&await this.sendCommand("QUIT",221)}catch(t){this.log(`Error during QUIT: ${t.message}`,!0)}finally{this.socket&&(this.socket.destroy(),this.socket=null,this.connected=!1)}}};var ce=class{smtpClient;config;constructor(t){let e=new xe(t).get(),r=new ke(e);this.smtpClient=r,this.config=e}async send(t){try{let e=Array.isArray(t.to)?t.to:[t.to];if(!this.config.skipMXRecordCheck)for(let s of e)await Te(s)||console.error(`Warning: No MX records found for recipient domain: ${s}`);let r=await this.smtpClient.sendEmail(t);r.success?console.log(`Message ID: ${r.messageId}`):console.error(`Failed to send email: ${r.error}`),await this.smtpClient.close()}catch(e){console.error("Error in email sending process:",e.message)}}};var le=()=>{let t=dt(process.env.DEBUG)||!1;return{auth:{jwtSecret:process.env.AUTH_JWT_SECRET||"your-jwt-secret",magicLinkExpirySeconds:900,jwtExpirySeconds:3600,refreshTokenExpirySeconds:604800,maxActiveSessions:3,appUrl:process.env.APP_URL||"http://localhost:3000",templates:null,debug:t},email:{emailSubject:"Your Secure Login Link",user:process.env.EMAIL_USER||"",host:process.env.EMAIL_HOST||"",password:process.env.EMAIL_PASSWORD||"",port:465,secure:!0,maxRetries:2,debug:t},storage:{databaseDirectory:"mikroauth",encryptionKey:process.env.STORAGE_KEY||"",debug:t},server:{port:Number(process.env.PORT)||3e3,host:process.env.HOST||"0.0.0.0",useHttps:!1,useHttp2:!1,sslCert:"",sslKey:"",sslCa:"",rateLimit:{enabled:!0,requestsPerMinute:100},allowedDomains:["*"],debug:t}}};function dt(t){return t==="true"||t===!0}var ht=class{algorithm="HS256";secret="HS256";constructor(t){if(process.env.NODE_ENV==="production"&&(!t||t.length<32||t===le().auth.jwtSecret))throw new Error("Production environment requires a strong JWT secret (min 32 chars)");this.secret=t}sign(t,e={}){let r={alg:this.algorithm,typ:"JWT"},s=Math.floor(Date.now()/1e3),i={...t,iat:s};e.exp!==void 0&&(i.exp=s+e.exp),e.notBefore!==void 0&&(i.nbf=s+e.notBefore),e.issuer&&(i.iss=e.issuer),e.audience&&(i.aud=e.audience),e.subject&&(i.sub=e.subject),e.jwtid&&(i.jti=e.jwtid);let a=this.base64UrlEncode(JSON.stringify(r)),o=this.base64UrlEncode(JSON.stringify(i)),h=`${a}.${o}`,d=this.createSignature(h);return`${h}.${d}`}verify(t,e={}){let r=this.decode(t);if(r.header.alg!==this.algorithm)throw new Error(`Invalid algorithm. Expected ${this.algorithm}, got ${r.header.alg}`);let[s,i]=t.split("."),a=`${s}.${i}`;if(this.createSignature(a)!==r.signature)throw new Error("Invalid signature");let o=r.payload,h=Math.floor(Date.now()/1e3),d=e.clockTolerance||0;if(o.exp!==void 0&&o.exp+d<h)throw new Error("Token expired");if(o.nbf!==void 0&&o.nbf-d>h)throw new Error("Token not yet valid");if(e.issuer&&o.iss!==e.issuer)throw new Error("Invalid issuer");if(e.audience&&o.aud!==e.audience)throw new Error("Invalid audience");if(e.subject&&o.sub!==e.subject)throw new Error("Invalid subject");return o}decode(t){let e=t.split(".");if(e.length!==3)throw new Error("Invalid token format");try{let[r,s,i]=e,a=JSON.parse(this.base64UrlDecode(r)),o=JSON.parse(this.base64UrlDecode(s));return{header:a,payload:o,signature:i}}catch{throw new Error("Failed to decode token")}}createSignature(t){let e=B.createHmac("sha256",this.secret).update(t).digest();return this.base64UrlEncode(e)}base64UrlEncode(t){let e;return typeof t=="string"?e=Buffer.from(t):e=t,e.toString("base64").replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}base64UrlDecode(t){let e=t.replace(/-/g,"+").replace(/_/g,"/");switch(e.length%4){case 0:break;case 2:e+="==";break;case 3:e+="=";break;default:throw new Error("Invalid base64 string")}return Buffer.from(e,"base64").toString()}},mt=class{templates;constructor(t){t?this.templates=t:this.templates=gt}getText(t,e,r){return this.templates.textVersion(t,e,r).trim()}getHtml(t,e,r){return this.templates.htmlVersion(t,e,r).trim()}},gt={textVersion:(t,e,r)=>`
Click this link to login: ${t}

Security Information:
- Expires in ${e} minutes
- Can only be used once
- Should only be used by you

If you didn't request this link, please ignore this email.
`,htmlVersion:(t,e,r)=>`
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Your Login Link</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      line-height: 1.6;
      color: #333;
      max-width: 600px;
      margin: 0 auto;
      padding: 20px;
    }
    .container {
      border: 1px solid #e1e1e1;
      border-radius: 5px;
      padding: 20px;
    }
    .button {
      display: inline-block;
      background-color: #4CAF50;
      color: white;
      text-decoration: none;
      padding: 10px 20px;
      border-radius: 5px;
      margin: 20px 0;
    }
    .security-info {
      background-color: #f8f8f8;
      padding: 15px;
      border-radius: 5px;
      margin-top: 20px;
    }
    .footer {
      margin-top: 20px;
      font-size: 12px;
      color: #888;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Your Secure Login Link</h2>
    <p>Click the button below to log in to your account:</p>
    <a href="${t}" class="button">Login to Your Account</a>

    <p>
      Hello, this is a test email! Hall\xE5, MikroMail has international support for, among others, espa\xF1ol, fran\xE7ais, portugu\xEAs, \u4E2D\u6587, \u65E5\u672C\u8A9E, and \u0420\u0443\u0441\u0441\u043A\u0438\u0439!
    </p>

    <div class="security-info">
      <h3>Security Information:</h3>
      <ul>
        <li>This link expires in ${e} minutes</li>
        <li>Can only be used once</li>
        <li>Should only be used by you</li>
      </ul>
    </div>

    <p>If you didn't request this link, please ignore this email.</p>

    <div class="footer">
      <p>This is an automated message, please do not reply to this email.</p>
    </div>
  </div>
</body>
</html>
`},ft=class{constructor(t){this.options=t}sentEmails=[];async sendMail(t){this.sentEmails.push(t),this.options?.logToConsole&&(console.log("Email sent:"),console.log(`From: ${t.from}`),console.log(`To: ${t.to}`),console.log(`Subject: ${t.subject}`),console.log(`Text: ${t.text}`)),this.options?.onSend&&this.options.onSend(t)}getSentEmails(){return[...this.sentEmails]}clearSentEmails(){this.sentEmails=[]}},pt=class{data=new Map;collections=new Map;expiryEmitter=new ut;expiryCheckInterval;constructor(t=1e3){this.expiryCheckInterval=setInterval(()=>this.checkExpiredItems(),t)}destroy(){clearInterval(this.expiryCheckInterval),this.data.clear(),this.collections.clear(),this.expiryEmitter.removeAllListeners()}checkExpiredItems(){let t=Date.now();for(let[e,r]of this.data.entries())r.expiry&&r.expiry<t&&(this.data.delete(e),this.expiryEmitter.emit("expired",e));for(let[e,r]of this.collections.entries())r.expiry&&r.expiry<t&&(this.collections.delete(e),this.expiryEmitter.emit("expired",e))}async set(t,e,r){let s=r?Date.now()+r*1e3:null;this.data.set(t,{value:e,expiry:s})}async get(t){let e=this.data.get(t);return e?e.expiry&&e.expiry<Date.now()?(this.data.delete(t),null):e.value:null}async delete(t){this.data.delete(t),this.collections.delete(t)}async addToCollection(t,e,r){this.collections.has(t)||this.collections.set(t,{items:[],expiry:r?Date.now()+r*1e3:null});let s=this.collections.get(t);s&&(r&&(s.expiry=Date.now()+r*1e3),s.items.push(e))}async removeFromCollection(t,e){let r=this.collections.get(t);r&&(r.items=r.items.filter(s=>s!==e))}async getCollection(t){let e=this.collections.get(t);return e?[...e.items]:[]}async getCollectionSize(t){let e=this.collections.get(t);return e?e.items.length:0}async removeOldestFromCollection(t){let e=this.collections.get(t);return!e||e.items.length===0?null:e.items.shift()||null}async findKeys(t){let e=t.replace(/\*/g,".*").replace(/\?/g,"."),r=new RegExp(`^${e}$`),s=Array.from(this.data.keys()).filter(a=>r.test(a)),i=Array.from(this.collections.keys()).filter(a=>r.test(a));return[...new Set([...s,...i])]}};function Ie(t){if(!t||t.trim()===""||(t.match(/@/g)||[]).length!==1)return!1;let[e,r]=t.split("@");return!(!e||!r||t.includes("..")||!yt(e)||!wt(r))}function yt(t){return t.startsWith('"')&&t.endsWith('"')?!t.slice(1,-1).includes('"'):t.length>64||t.startsWith(".")||t.endsWith(".")?!1:/^[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+$/.test(t)}function wt(t){if(t.startsWith("[")&&t.endsWith("]")){let r=t.slice(1,-1);return r.startsWith("IPv6:")?vt(r.slice(5)):bt(r)}let e=t.split(".");if(e.length===0)return!1;for(let r of e)if(!r||r.length>63||!/^[a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?$/.test(r))return!1;if(e.length>1){let r=e[e.length-1];if(!/^[a-zA-Z]{2,}$/.test(r))return!1}return!0}function bt(t){return/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}$/.test(t)}function vt(t){if(!/^[a-fA-F0-9:]+$/.test(t))return!1;let e=t.split(":");return!(e.length<2||e.length>8)}var x=le(),Et=t=>{let e={configFilePath:"mikroauth.config.json",args:process.argv,options:[{flag:"--jwtSecret",path:"auth.jwtSecret",defaultValue:x.auth.jwtSecret},{flag:"--magicLinkExpirySeconds",path:"auth.magicLinkExpirySeconds",defaultValue:x.auth.magicLinkExpirySeconds},{flag:"--jwtExpirySeconds",path:"auth.jwtExpirySeconds",defaultValue:x.auth.jwtExpirySeconds},{flag:"--refreshTokenExpirySeconds",path:"auth.refreshTokenExpirySeconds",defaultValue:x.auth.refreshTokenExpirySeconds},{flag:"--maxActiveSessions",path:"auth.maxActiveSessions",defaultValue:x.auth.maxActiveSessions},{flag:"--appUrl",path:"auth.appUrl",defaultValue:x.auth.appUrl},{flag:"--debug",path:"auth.debug",isFlag:!0,defaultValue:x.auth.debug},{flag:"--emailSubject",path:"email.emailSubject",defaultValue:"Your Secure Login Link"},{flag:"--emailHost",path:"email.host",defaultValue:x.email.host},{flag:"--emailUser",path:"email.user",defaultValue:x.email.user},{flag:"--emailPassword",path:"email.password",defaultValue:x.email.password},{flag:"--emailPort",path:"email.port",defaultValue:x.email.port},{flag:"--emailSecure",path:"email.secure",isFlag:!0,defaultValue:x.email.secure},{flag:"--emailMaxRetries",path:"email.maxRetries",defaultValue:x.email.maxRetries},{flag:"--debug",path:"email.debug",isFlag:!0,defaultValue:x.email.debug},{flag:"--dir",path:"storage.databaseDirectory",defaultValue:x.storage.databaseDirectory},{flag:"--encryptionKey",path:"storage.encryptionKey",defaultValue:x.storage.encryptionKey},{flag:"--debug",path:"storage.debug",defaultValue:x.storage.debug},{flag:"--port",path:"server.port",defaultValue:x.server.port},{flag:"--host",path:"server.host",defaultValue:x.server.host},{flag:"--https",path:"server.useHttps",isFlag:!0,defaultValue:x.server.useHttps},{flag:"--https",path:"server.useHttp2",isFlag:!0,defaultValue:x.server.useHttp2},{flag:"--cert",path:"server.sslCert",defaultValue:x.server.sslCert},{flag:"--key",path:"server.sslKey",defaultValue:x.server.sslKey},{flag:"--ca",path:"server.sslCa",defaultValue:x.server.sslCa},{flag:"--ratelimit",path:"server.rateLimit.enabled",defaultValue:x.server.rateLimit.enabled,isFlag:!0},{flag:"--rps",path:"server.rateLimit.requestsPerMinute",defaultValue:x.server.rateLimit.requestsPerMinute},{flag:"--allowed",path:"server.allowedDomains",defaultValue:x.server.allowedDomains,parser:D.array},{flag:"--debug",path:"server.debug",isFlag:!0,defaultValue:x.server.debug}]};return t&&(e.config=t),e},G={linkSent:"If a matching account was found, a magic link has been sent.",revokedSuccess:"All other sessions revoked successfully.",logoutSuccess:"Logged out successfully."},Me=class{config;email;storage;jwtService;templates;constructor(t,e,r){let s=new L(Et({auth:t.auth,email:t.email})).get();s.auth.debug&&console.log("Using configuration:",s),this.config=s,this.email=e||new ft,this.storage=r||new pt,this.jwtService=new ht(s.auth.jwtSecret),this.templates=new mt(s?.auth.templates),this.checkIfUsingDefaultCredentialsInProduction()}checkIfUsingDefaultCredentialsInProduction(){process.env.NODE_ENV==="production"&&this.config.auth.jwtSecret===le().auth.jwtSecret&&(console.error("WARNING: Using default secrets in production environment!"),process.exit(1))}generateToken(t){let e=Date.now().toString(),r=B.randomBytes(32).toString("hex");return B.createHash("sha256").update(`${t}:${e}:${r}`).digest("hex")}generateJsonWebToken(t){return this.jwtService.sign({sub:t.id,email:t.email,username:t.username,role:t.role,exp:Math.floor(Date.now()/1e3)+3600*24})}generateRefreshToken(){return B.randomBytes(40).toString("hex")}async trackSession(t,e,r){let s=`sessions:${t}`;if(await this.storage.getCollectionSize(s)>=this.config.auth.maxActiveSessions){let i=await this.storage.removeOldestFromCollection(s);i&&await this.storage.delete(`refresh:${i}`)}await this.storage.addToCollection(s,e,this.config.auth.refreshTokenExpirySeconds),await this.storage.set(`refresh:${e}`,JSON.stringify(r),this.config.auth.refreshTokenExpirySeconds)}generateMagicLinkUrl(t){let{token:e,email:r,appUrl:s}=t,i=s||this.config.auth.appUrl;try{return new lt(i),`${i}?token=${encodeURIComponent(e)}&email=${encodeURIComponent(r)}`}catch{throw new Error("Invalid base URL configuration")}}async createMagicLink(t){let{email:e,ip:r,metadata:s,appUrl:i,subject:a}=t;if(!Ie(e))throw new Error("Valid email required");try{let o=this.generateToken(e),h=`magic_link:${o}`,d={email:e,ipAddress:r||"unknown",createdAt:Date.now()};await this.storage.set(h,JSON.stringify(d),this.config.auth.magicLinkExpirySeconds);let y=await this.storage.findKeys("magic_link:*");for(let n of y){if(n===h)continue;let u=await this.storage.get(n);if(u)try{JSON.parse(u).email===e&&await this.storage.delete(n)}catch{}}let w=this.generateMagicLinkUrl({token:o,email:e,appUrl:i}),f=Math.ceil(this.config.auth.magicLinkExpirySeconds/60);return await this.email.sendMail({from:this.config.email.user,to:e,subject:a||this.config.email.emailSubject,text:this.templates.getText(w,f,s),html:this.templates.getHtml(w,f,s)}),{message:G.linkSent}}catch(o){throw console.error(`Failed to process magic link request: ${o}`),new Error("Failed to process magic link request")}}async createToken(t){let{email:e,username:r,role:s,ip:i}=t;if(!Ie(e))throw new Error("Valid email required");try{let a=B.randomBytes(16).toString("hex"),o=this.generateRefreshToken(),h=Date.now(),d={sub:e,username:r,role:s,jti:a,lastLogin:h,metadata:{ip:i||"unknown"},exp:Math.floor(Date.now()/1e3)+3600*24},y=this.jwtService.sign(d,{exp:this.config.auth.jwtExpirySeconds}),w={email:e,username:r,role:s,ipAddress:i||"unknown",tokenId:a,createdAt:h,lastLogin:h};return await this.trackSession(e,o,w),{accessToken:y,refreshToken:o,exp:this.config.auth.jwtExpirySeconds,tokenType:"Bearer"}}catch(a){throw console.error("Token creation error:",a),new Error("Token creation failed")}}async verifyToken(t){let{token:e,email:r}=t;try{let s=`magic_link:${e}`,i=await this.storage.get(s);if(!i)throw new Error("Invalid or expired token");let a=JSON.parse(i);if(a.email!==r)throw new Error("Email mismatch");let o=a.username,h=a.role;await this.storage.delete(s);let d=B.randomBytes(16).toString("hex"),y=this.generateRefreshToken(),w={sub:r,username:o,role:h,jti:d,lastLogin:a.createdAt,metadata:{ip:a.ipAddress},exp:Math.floor(Date.now()/1e3)+3600*24},f=this.jwtService.sign(w,{exp:this.config.auth.jwtExpirySeconds});return await this.trackSession(r,y,{...a,tokenId:d,createdAt:Date.now()}),{accessToken:f,refreshToken:y,exp:this.config.auth.jwtExpirySeconds,tokenType:"Bearer"}}catch(s){throw console.error("Token verification error:",s),new Error("Verification failed")}}async refreshAccessToken(t){try{let e=await this.storage.get(`refresh:${t}`);if(!e)throw new Error("Invalid or expired refresh token");let r=JSON.parse(e),s=r.email;if(!s)throw new Error("Invalid refresh token data");let i=r.username,a=r.role,o=B.randomBytes(16).toString("hex"),h={sub:s,username:i,role:a,jti:o,lastLogin:r.lastLogin||r.createdAt,metadata:{ip:r.ipAddress}},d=this.jwtService.sign(h,{exp:this.config.auth.jwtExpirySeconds});return r.lastUsed=Date.now(),await this.storage.set(`refresh:${t}`,JSON.stringify(r),this.config.auth.refreshTokenExpirySeconds),{accessToken:d,refreshToken:t,exp:this.config.auth.jwtExpirySeconds,tokenType:"Bearer"}}catch(e){throw console.error("Token refresh error:",e),new Error("Token refresh failed")}}verify(t){try{return this.jwtService.verify(t)}catch{throw new Error("Invalid token")}}async logout(t){try{if(!t||typeof t!="string")throw new Error("Refresh token is required");let e=await this.storage.get(`refresh:${t}`);if(!e)return{message:G.logoutSuccess};let r=JSON.parse(e).email;if(!r)throw new Error("Invalid refresh token data");await this.storage.delete(`refresh:${t}`);let s=`sessions:${r}`;return await this.storage.removeFromCollection(s,t),{message:G.logoutSuccess}}catch(e){throw console.error("Logout error:",e),new Error("Logout failed")}}async getSessions(t){try{if(!t.user?.email)throw new Error("User not authenticated");let e=t.user.email,r=t.body?.refreshToken,s=`sessions:${e}`,i=(await this.storage.getCollection(s)).map(async o=>{try{let h=await this.storage.get(`refresh:${o}`);if(!h)return await this.storage.removeFromCollection(s,o),null;let d=JSON.parse(h);return{id:`${o.substring(0,8)}...`,createdAt:d.createdAt||0,lastLogin:d.lastLogin||d.createdAt||0,lastUsed:d.lastUsed||d.createdAt||0,metadata:{ip:d.ipAddress},isCurrentSession:o===r}}catch{return await this.storage.removeFromCollection(s,o),null}}),a=(await Promise.all(i)).filter(Boolean);return a.sort((o,h)=>h.createdAt-o.createdAt),{sessions:a}}catch(e){throw console.error("Get sessions error:",e),new Error("Failed to fetch sessions")}}async revokeSessions(t){try{if(!t.user?.email)throw new Error("User not authenticated");let e=t.user.email,r=t.body?.refreshToken,s=`sessions:${e}`,i=await this.storage.getCollection(s);for(let a of i)r&&a===r||await this.storage.delete(`refresh:${a}`);return await this.storage.delete(s),r&&await this.storage.get(`refresh:${r}`)&&await this.storage.addToCollection(s,r,this.config.auth.refreshTokenExpirySeconds),{message:G.revokedSuccess}}catch(e){throw console.error("Revoke sessions error:",e),new Error("Failed to revoke sessions")}}authenticate(t,e){try{let r=t.headers?.authorization;if(!r||!r.startsWith("Bearer "))throw new Error("Authentication required");let s=r.split(" ")[1];try{let i=this.verify(s);t.user={email:i.sub},e()}catch{throw new Error("Invalid or expired token")}}catch(r){e(r)}}},Ct=class{key;algorithm="aes-256-gcm";keyLength=32;constructor(t){this.key=it(t,"mikroauth-salt",this.keyLength)}encrypt(t){let e=at(12),r=ot(this.algorithm,this.key,e),s=Buffer.concat([r.update(t,"utf8"),r.final()]),i=r.getAuthTag();return`${e.toString("hex")}:${i.toString("hex")}:${s.toString("hex")}`}decrypt(t){let e=t.split(":");if(e.length!==3)throw new Error("Invalid encrypted data format");let[r,s,i]=e,a=Buffer.from(r,"hex"),o=Buffer.from(s,"hex"),h=Buffer.from(i,"hex"),d=ct(this.algorithm,this.key,a);return d.setAuthTag(o),Buffer.concat([d.update(h),d.final()]).toString("utf8")}},Pe=class{db;encryption;PREFIX_KV="kv:";PREFIX_COLLECTION="coll:";TABLE_NAME="mikroauth";constructor(t,e){this.db=t,e&&(this.encryption=new Ct(e))}async start(){await this.db.start()}async close(){await this.db.close()}async set(t,e,r){let s=`${this.PREFIX_KV}${t}`,i=this.encryption?this.encryption.encrypt(e):e,a=r?Date.now()+r*1e3:void 0;await this.db.write(this.TABLE_NAME,s,i,a)}async get(t){let e=`${this.PREFIX_KV}${t}`,r=await this.db.get(this.TABLE_NAME,e);return r?this.encryption?this.encryption.decrypt(r):r:null}async delete(t){let e=`${this.PREFIX_KV}${t}`;await this.db.delete(this.TABLE_NAME,e)}async addToCollection(t,e,r){let s=`${this.PREFIX_COLLECTION}${t}`,i=await this.db.get(this.TABLE_NAME,s),a=[];if(i){let y=this.encryption?this.encryption.decrypt(i):i;a=JSON.parse(y)}a.includes(e)||a.push(e);let o=JSON.stringify(a),h=this.encryption?this.encryption.encrypt(o):o,d=r?Date.now()+r*1e3:void 0;await this.db.write(this.TABLE_NAME,s,h,d)}async removeFromCollection(t,e){let r=`${this.PREFIX_COLLECTION}${t}`,s=await this.db.get(this.TABLE_NAME,r);if(!s)return;let i=this.encryption?this.encryption.decrypt(s):s,a=JSON.parse(i);a=a.filter(d=>d!==e);let o=JSON.stringify(a),h=this.encryption?this.encryption.encrypt(o):o;await this.db.write(this.TABLE_NAME,r,h)}async getCollection(t){let e=`${this.PREFIX_COLLECTION}${t}`,r=await this.db.get(this.TABLE_NAME,e);if(!r)return[];let s=this.encryption?this.encryption.decrypt(r):r;return JSON.parse(s)}async getCollectionSize(t){return(await this.getCollection(t)).length}async removeOldestFromCollection(t){let e=`${this.PREFIX_COLLECTION}${t}`,r=await this.db.get(this.TABLE_NAME,e);if(!r)return null;let s=this.encryption?this.encryption.decrypt(r):r,i=JSON.parse(s);if(i.length===0)return null;let a=i.shift(),o=JSON.stringify(i),h=this.encryption?this.encryption.encrypt(o):o;return await this.db.write(this.TABLE_NAME,e,h),a}async findKeys(t){let e=t.replace(/\./g,"\\.").replace(/\*/g,".*").replace(/\?/g,"."),r=new RegExp(`^${e}$`),s=await this.db.get(this.TABLE_NAME);return Array.isArray(s)?s.filter(i=>{let a=i[0];return typeof a=="string"&&a.startsWith(this.PREFIX_KV)}).map(i=>i[0].substring(this.PREFIX_KV.length)).filter(i=>r.test(i)):[]}},Ue=class{email;sender;constructor(t){this.sender=t.user,this.email=new ce({config:t})}async sendMail(t){await this.email.send({from:this.sender,to:t.to,cc:t.cc,bcc:t.bcc,subject:t.subject,text:t.text,html:t.html})}};function J(t){if(!t.deflate&&!t.inflate)throw new Error("Dictionary must provide either deflate or inflate mapping");if(t.deflate&&t.inflate)throw new Error("Dictionary should provide only one of deflate or inflate (not both). The inverse will be auto-generated.");return t.deflate?{deflate:t.deflate,inflate:je(t.deflate)}:{deflate:je(t.inflate),inflate:t.inflate}}function je(t){let e={};for(let[r,s]of Object.entries(t))e[s]=r;return e}function H(t,e){if(t==null||typeof t!="object")return t;if(Array.isArray(t))return t.map(s=>H(s,e));let r={};for(let[s,i]of Object.entries(t)){let a=e[s]||s;r[a]=H(i,e)}return r}function R(t){if(!t||typeof t!="string")throw new Error("Table name must be a non-empty string");if(t.length>255)throw new Error("Table name must not exceed 255 characters");if(t.includes("/")||t.includes("\\"))throw new Error("Table name must not contain path separators");if(t.includes(".."))throw new Error('Table name must not contain ".."');if(t.startsWith("."))throw new Error('Table name must not start with "."');if(t.includes("\0"))throw new Error("Table name must not contain null bytes");if(["CON","PRN","AUX","NUL","COM1","COM2","COM3","COM4","COM5","COM6","COM7","COM8","COM9","LPT1","LPT2","LPT3","LPT4","LPT5","LPT6","LPT7","LPT8","LPT9"].includes(t.toUpperCase()))throw new Error(`Table name "${t}" is reserved by the filesystem`)}function Y(t){if(t==null)throw new Error("Key must be defined");if(typeof t!="string")throw new Error("Key must be a string");if(t.length===0)throw new Error("Key must not be empty");if(t.length>1024)throw new Error("Key must not exceed 1024 characters");if(t.includes("\0"))throw new Error("Key must not contain null bytes")}function $e(t){if(t===void 0)throw new Error("Value must not be undefined (use null instead)");let e=typeof t;if(e==="function")throw new Error("Value must be JSON-serializable: functions are not supported");if(e==="symbol")throw new Error("Value must be JSON-serializable: symbols are not supported");try{if(JSON.stringify(t)===void 0)throw new Error("Value must be JSON-serializable: value cannot be serialized")}catch(r){throw new Error(`Value must be JSON-serializable: ${r instanceof Error?r.message:String(r)}`)}}import{existsSync as ue,mkdirSync as St,readdirSync as xt,openSync as Tt,closeSync as At}from"fs";import{readFile as kt,writeFile as It,rename as Mt,unlink as Le,open as Pt}from"fs/promises";import{join as de,dirname as Ut}from"path";var he=class{data=new Map;databaseDirectory;dictionaries=new Map;useFsync;constructor(t){this.databaseDirectory=t.databaseDirectory,this.useFsync=t.durableWrites??!1,t.dictionaries&&Object.entries(t.dictionaries).forEach(([e,r])=>{let s=J(r);this.dictionaries.set(e,s)}),ue(this.databaseDirectory)||St(this.databaseDirectory,{recursive:!0})}async start(){try{let t=xt(this.databaseDirectory);for(let e of t)!e.endsWith(".tmp")&&!e.startsWith(".")&&await this.loadTable(e)}catch(t){throw console.error("Failed to start database:",t),t}}async write(t,e,r,s,i){if(R(t),Y(e),$e(r),i&&!this.dictionaries.has(i))throw new Error(`Dictionary "${i}" not found. Available dictionaries: ${Array.from(this.dictionaries.keys()).join(", ")||"none"}`);try{this.data.has(t)||this.data.set(t,new Map);let a=this.data.get(t),h=(a.get(e)?.version||0)+1,d={value:r,version:h,timestamp:Date.now(),expiration:s||null,dictionaryName:i||void 0};return a.set(e,d),await this.persistTable(t),!0}catch(a){return console.error(`Write failed for ${t}:${e}:`,a),!1}}async get(t,e){R(t),e!==void 0&&Y(e);try{this.data.has(t)||await this.loadTable(t);let r=this.data.get(t);if(!r)return e?void 0:[];if(e!==void 0){let a=r.get(e);if(!a)return;if(this.isExpired(a)){r.delete(e),await this.persistTable(t);return}return a.value}let s=[],i=[];for(let[a,o]of r.entries())this.isExpired(o)?i.push(a):s.push([a,o.value]);if(i.length>0){for(let a of i)r.delete(a);await this.persistTable(t)}return s}catch(r){return console.error(`Read failed for ${t}:${e}:`,r),e?void 0:[]}}async delete(t,e){R(t),Y(e);try{this.data.has(t)||await this.loadTable(t);let r=this.data.get(t);if(!r||!r.has(e))return!1;let s=r.get(e);return s?this.isExpired(s)?(r.delete(e),await this.persistTable(t),!1):(r.delete(e),await this.persistTable(t),!0):!1}catch(r){return console.error(`Delete failed for ${t}:${e}:`,r),!1}}async getTableSize(t){R(t);try{this.data.has(t)||await this.loadTable(t);let e=this.data.get(t);if(!e)return 0;let r=0,s=[];for(let[i,a]of e.entries())this.isExpired(a)?s.push(i):r++;if(s.length>0){for(let i of s)e.delete(i);await this.persistTable(t)}return r}catch(e){return console.error(`Get table size failed for ${t}:`,e),0}}isExpired(t){return t.expiration===null?!1:Date.now()>t.expiration}async cleanupExpired(t){R(t);try{this.data.has(t)||await this.loadTable(t);let e=this.data.get(t);if(!e)return 0;let r=[];for(let[s,i]of e.entries())this.isExpired(i)&&r.push(s);for(let s of r)e.delete(s);return r.length>0&&await this.persistTable(t),r.length}catch(e){return console.error(`Cleanup failed for ${t}:`,e),0}}async cleanupAllExpired(){let t=0;for(let e of this.data.keys())t+=await this.cleanupExpired(e);return t}async deleteTable(t){R(t);try{this.data.delete(t);let e=de(this.databaseDirectory,t);return ue(e)&&await Le(e),!0}catch(e){return console.error(`Delete table failed for ${t}:`,e),!1}}listTables(){return Array.from(this.data.keys())}async flush(){try{let t=Array.from(this.data.keys()).map(e=>this.persistTable(e));await Promise.all(t)}catch(t){throw console.error("Flush failed:",t),t}}async close(){await this.flush()}addDictionary(t,e){let r=J(e);this.dictionaries.set(t,r)}removeDictionary(t){return this.dictionaries.delete(t)}listDictionaries(){return Array.from(this.dictionaries.keys())}async loadTable(t){let e=de(this.databaseDirectory,t);if(!ue(e)){this.data.set(t,new Map);return}try{let r=await kt(e);if(r.length===0){this.data.set(t,new Map);return}let s=this.deserializeTable(r);this.data.set(t,s)}catch(r){console.error(`Failed to load table ${t}:`,r),this.data.set(t,new Map)}}async persistTable(t){let e=this.data.get(t);if(!e)return;let r=this.serializeTable(e),s=de(this.databaseDirectory,t),i=`${s}.tmp.${Date.now()}.${Math.random().toString(36).substring(7)}`;try{if(await It(i,r),this.useFsync){let a=await Pt(i,"r+");try{await a.sync()}finally{await a.close()}}if(await Mt(i,s),this.useFsync){let a=Ut(s),o=Tt(a,"r");try{At(o)}catch{}}}catch(a){try{await Le(i)}catch{}throw a}}serializeTable(t){let e=Array.from(t.entries()).map(([r,s])=>{let i=s.dictionaryName?this.dictionaries.get(s.dictionaryName):void 0,a={d:i?H(s.value,i.deflate):s.value,v:s.version,t:s.timestamp,x:s.expiration};return s.dictionaryName&&(a.n=s.dictionaryName),[r,a]});return Buffer.from(JSON.stringify(e),"utf8")}deserializeTable(t){let r=JSON.parse(t.toString("utf8")).map(([s,i])=>{let a=i.n,o=a?this.dictionaries.get(a):void 0;return[s,{value:o?H(i.d,o.inflate):i.d,version:i.v,timestamp:i.t,expiration:i.x,dictionaryName:a||void 0}]});return new Map(r)}};import{randomBytes as Be,scrypt as Re,timingSafeEqual as Lt}from"node:crypto";import{EventEmitter as Dt}from"node:events";import{getRandomValues as jt}from"node:crypto";var q=class{options;defaultLength=16;defaultOnlyLowerCase=!1;defaultStyle="extended";defaultUrlSafe=!0;constructor(t){if(this.options={},t)for(let[e,r]of Object.entries(t))this.options[e]=this.generateConfig(r)}add(t){if(!t?.name)throw new Error("Missing name for the ID configuration");let e=this.generateConfig(t);this.options[t.name]=e}remove(t){if(!t?.name)throw new Error("Missing name for the ID configuration");delete this.options[t.name]}create(t,e,r,s){let i=this.generateConfig({length:t,style:e,onlyLowerCase:r,urlSafe:s});return this.generateId(i)}custom(t){if(this.options[t])return this.generateId(this.options[t]);throw new Error(`No configuration found with name: ${t}`)}generateConfig(t){return{name:t?.name||"",length:t?.length||this.defaultLength,onlyLowerCase:t?.onlyLowerCase??this.defaultOnlyLowerCase,style:t?.style||this.defaultStyle,urlSafe:t?.urlSafe??this.defaultUrlSafe}}getCharacterSet(t,e,r){if(t==="hex")return e?"0123456789abcdef":"0123456789ABCDEFabcdef";if(t==="alphanumeric")return e?"abcdefghijklmnopqrstuvwxyz0123456789":"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";if(t==="extended")return r?e?"abcdefghijklmnopqrstuvwxyz0123456789-._~":"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~":e?"abcdefghijklmnopqrstuvwxyz0123456789-._~!$()*+,;=:":"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~!$()*+,;=:";throw new Error(`Unknown ID style "${t} provided. Must be one of "extended" (default), "alphanumeric", or "hex".`)}generateId(t){let{length:e,onlyLowerCase:r,style:s,urlSafe:i}=t;if(e<0||e===0)throw new Error("ID length cannot be negative");let a=this.getCharacterSet(s,r,i),o=(2<<Math.log(a.length-1)/Math.LN2)-1,h=Math.ceil(1.6*o*e/a.length),d="";for(;d.length<e;){let y=new Uint8Array(h);jt(y);for(let w=0;w<h;w++){let f=y[w]&o;if(f<a.length&&(d+=a[f],d.length===e))break}}return d}};var j=class t{async getUserById(e){return this.db.get(`user:${e}`)}async getUserByUsername(e){return(await this.db.list("user:")).find(s=>s.userName===e)||null}async createUser(e){await this.db.set(`user:${e.id}`,e)}async deleteUser(e){await this.db.delete(`user:${e}`)}async listUsers(){return this.db.list("user:")}async getUserByEmail(e){return(await this.db.list("user:")).find(s=>s.email===e)||null}async getChannelById(e){return this.db.get(`channel:${e}`)}async getChannelByName(e){return(await this.db.list("channel:")).find(s=>s.name===e)||null}async createChannel(e){await this.db.set(`channel:${e.id}`,e)}async updateChannel(e){await this.db.set(`channel:${e.id}`,e)}async deleteChannel(e){await this.db.delete(`channel:${e}`),await this.db.delete(`idx:channel-msgs:${e}`)}async listChannels(){return this.db.list("channel:")}async getMessageById(e){return await this.db.get(`message:${e}`)}async listMessagesByChannel(e,r){let s=await this.getIndex(`idx:channel-msgs:${e}`);return this.paginateAndFetch(s,r)}async createMessage(e){await this.db.set(`message:${e.id}`,e),e.threadId?await this.appendToIndex(`idx:thread-msgs:${e.threadId}`,e.id):e.channelId.startsWith("dm:")?await this.appendToIndex(`idx:conv-msgs:${e.channelId}`,e.id):await this.appendToIndex(`idx:channel-msgs:${e.channelId}`,e.id)}async updateMessage(e){await this.db.set(`message:${e.id}`,e)}async deleteMessage(e){let r=await this.db.get(`message:${e}`);await this.db.delete(`message:${e}`),r&&(r.threadId?await this.removeFromIndex(`idx:thread-msgs:${r.threadId}`,e):r.channelId.startsWith("dm:")?await this.removeFromIndex(`idx:conv-msgs:${r.channelId}`,e):await this.removeFromIndex(`idx:channel-msgs:${r.channelId}`,e))}async addReaction(e,r,s){let i=await this.getMessageById(e);if(!i)return null;i.reactions||(i.reactions={});let a=i.reactions[r]||[];return a.includes(s)||(i.reactions[r]=[...a,s],await this.updateMessage(i)),i}async removeReaction(e,r,s){let i=await this.getMessageById(e);return i?(!i.reactions||!i.reactions[r]||(i.reactions[r]=i.reactions[r].filter(a=>a!==s),await this.updateMessage(i)),i):null}async getServerSettings(){return this.db.get("server:settings")}async updateServerSettings(e){await this.db.set("server:settings",e)}static generateConversationId(e,r){let s=[e,r].sort();return`dm:${s[0]}_${s[1]}`}async getConversationById(e){return this.db.get(`conversation:${e}`)}async getConversationByParticipants(e,r){let s=t.generateConversationId(e,r);return this.getConversationById(s)}async createConversation(e){await this.db.set(`conversation:${e.id}`,e)}async updateConversation(e){await this.db.set(`conversation:${e.id}`,e)}async listConversationsForUser(e){return(await this.db.list("conversation:")).filter(s=>s.participants.includes(e)).sort((s,i)=>(i.lastMessageAt||i.createdAt)-(s.lastMessageAt||s.createdAt))}async listMessagesByConversation(e,r){let s=await this.getIndex(`idx:conv-msgs:${e}`);return this.paginateAndFetch(s,r)}async listMessagesByThread(e,r){let s=await this.getIndex(`idx:thread-msgs:${e}`);return this.paginateAndFetch(s,r)}async getWebhookById(e){return this.db.get(`webhook:${e}`)}async getWebhookByToken(e){return(await this.db.list("webhook:")).find(s=>s.token===e)||null}async listWebhooks(){return this.db.list("webhook:")}async listWebhooksByChannel(e){return(await this.db.list("webhook:")).filter(s=>s.channelId===e)}async createWebhook(e){await this.db.set(`webhook:${e.id}`,e)}async deleteWebhook(e){await this.db.delete(`webhook:${e}`)}async getIndex(e){return await this.db.get(e)||[]}async appendToIndex(e,r){let s=await this.getIndex(e);s.push(r),await this.db.set(e,s)}async removeFromIndex(e,r){let i=(await this.getIndex(e)).filter(a=>a!==r);await this.db.set(e,i)}async paginateAndFetch(e,r){if(e.length===0)return[];let s=r?.limit??0,i=r?.before,a;if(i){let h=e.indexOf(i);if(h<=0)return[];let d=s>0?Math.max(0,h-s):0;a=e.slice(d,h)}else s>0?a=e.slice(-s):a=e;let o=[];for(let h of a){let d=await this.db.get(`message:${h}`);d&&o.push(d)}return o.sort((h,d)=>h.createdAt-d.createdAt)}};var X=class extends j{db;constructor(){super(),this.db=new me}},me=class{data={};async get(e){return this.data[e]||null}async set(e,r){this.data[e]=r}async delete(e){delete this.data[e]}async list(e){let r=[];for(let s in this.data)s.startsWith(e)&&r.push(this.data[s]);return r}};var M="mikrochat_id",ge={name:M,length:12,urlSafe:!0},De=()=>{let t=$t(process.env.DEBUG)||!1;return{auth:{jwtSecret:process.env.AUTH_JWT_SECRET||"your-jwt-secret",magicLinkExpirySeconds:900,jwtExpirySeconds:900,refreshTokenExpirySeconds:10080*60,maxActiveSessions:3,appUrl:process.env.APP_URL||"http://127.0.0.1:3000",authMode:"magic-link",isInviteRequired:!0,debug:t},email:{emailSubject:"Your Secure Login Link",user:process.env.EMAIL_USER||"",host:process.env.EMAIL_HOST||"",password:process.env.EMAIL_PASSWORD||"",port:465,secure:!0,maxRetries:2,debug:t},storage:{databaseDirectory:"mikrochat_db",encryptionKey:process.env.STORAGE_KEY||"",debug:t},server:{port:Number(process.env.PORT)||3e3,host:process.env.HOST||"localhost",useHttps:!1,useHttp2:!1,sslCert:"",sslKey:"",sslCa:"",rateLimit:{enabled:!0,requestsPerMinute:100},allowedDomains:["http://127.0.0.1:8000"],debug:t},chat:{initialUser:{id:process.env.INITIAL_USER_ID||new q().add(ge),userName:process.env.INITIAL_USER_NAME||"",email:process.env.INITIAL_USER_EMAIL||"",password:process.env.INITIAL_USER_PASSWORD||""},messageRetentionDays:30,maxMessagesPerChannel:100},oauth:void 0}};function $t(t){return t==="true"||t===!0}var $=class t{config;db;id;eventEmitter;generalChannelName="General";constructor(e,r){this.config=e,this.db=r||new X,this.id=new q,this.eventEmitter=new Dt,this.eventEmitter.setMaxListeners(0),this.initialize()}async initialize(){let e=this.config.initialUser.id,r=this.config.initialUser.userName,s=this.config.initialUser.email;if(!r||!s)throw new Error('Missing required data to start a new MikroChat server. Required arguments are "initialUser.userName" and "initialUser.email".');this.id.add(ge);let i=await this.getUserByEmail(s);if(i||await this.createUser({id:e||this.id.custom(M),userName:r||s.split("@")[0],email:s,isAdmin:!0,createdAt:Date.now()}),this.config.initialUser.password){let o=i||await this.getUserByEmail(s);o&&!o.passwordHash&&await this.setUserPassword(o.id,this.config.initialUser.password)}await this.db.getChannelByName(this.generalChannelName)||await this.db.createChannel({id:this.id.custom(M),name:this.generalChannelName,createdAt:Date.now(),createdBy:this.config.initialUser.id}),this.scheduleMessageCleanup()}scheduleMessageCleanup(){setInterval(async()=>{let s=await this.db.listChannels(),i=1440*60*1e3,a=Date.now()-this.config.messageRetentionDays*i;for(let o of s){let h=await this.db.getIndex(`idx:channel-msgs:${o.id}`);for(let y of h){let w=await this.db.getMessageById(y);if(w&&w.createdAt<a){let f=await this.db.listMessagesByThread(w.id);for(let n of f)await this.db.deleteMessage(n.id);await this.db.deleteMessage(w.id),this.emitEvent({type:"DELETE_MESSAGE",payload:{id:w.id,channelId:o.id}})}}let d=await this.db.getIndex(`idx:channel-msgs:${o.id}`);if(d.length>this.config.maxMessagesPerChannel){let y=d.length-this.config.maxMessagesPerChannel,w=d.slice(0,y);for(let f of w)await this.db.deleteMessage(f),this.emitEvent({type:"DELETE_MESSAGE",payload:{id:f,channelId:o.id}})}}},36e5)}async getServerSettings(){return await this.db.getServerSettings()}async updateServerSettings(e){await this.db.updateServerSettings(e),this.emitEvent({type:"UPDATE_SERVER_SETTINGS",payload:{name:e.name}})}async getMessageById(e){return await this.db.getMessageById(e)}async listUsers(){return await this.db.listUsers()}async getUserById(e){return await this.db.getUserById(e)}async getUserByEmail(e){return await this.db.getUserByEmail(e)}async createUser(e){return await this.db.createUser(e)}async deleteUser(e){await this.db.deleteUser(e)}async addUser(e,r="",s=!1,i=!1){let a=await this.getUserById(r);if(!i&&!a)throw new Error("User not found");if(s&&!a?.isAdmin)throw new Error("Only administrators can add admin users");if(await this.getUserByEmail(e))throw new Error("User with this email already exists");let h=this.id.custom(M),d={id:h,userName:e.split("@")[0],email:e,isAdmin:s,createdAt:Date.now(),addedBy:r||h};return await this.createUser(d),this.emitEvent({type:"NEW_USER",payload:{id:d.id,userName:d.userName,email:d.email}}),d}async removeUser(e,r){let s=await this.getUserById(e);if(!s)throw new Error("User not found");let i=await this.getUserById(r);if(!i)throw new Error("Requester not found");if(!i.isAdmin)throw new Error("Only administrators can remove users");if(s.isAdmin&&(await this.listUsers()).filter(o=>o.isAdmin).length<=1)throw new Error("Cannot remove the last administrator");await this.deleteUser(e),this.emitEvent({type:"REMOVE_USER",payload:{id:e,email:s.email}})}async exitUser(e){let r=await this.getUserById(e);if(!r)throw new Error("User not found");await this.deleteUser(e),this.emitEvent({type:"USER_EXIT",payload:{id:e,userName:r.userName}})}async updateUserName(e,r){let s=r.trim();if(!s)throw new Error("User name cannot be empty");let i=await this.getUserById(e);if(!i)throw new Error("User not found");let a=await this.db.getUserByUsername(s);if(a&&a.id!==e)throw new Error("User name is already taken");let o={...i,userName:s};return await this.createUser(o),this.emitEvent({type:"UPDATE_USER",payload:{id:e,userName:s}}),o}static MIN_PASSWORD_LENGTH=8;async hashPassword(e){let r=Be(16).toString("hex"),s=await new Promise((i,a)=>{Re(e,r,64,(o,h)=>{o?a(o):i(h)})});return`${r}:${s.toString("hex")}`}async verifyPasswordHash(e,r){let[s,i]=r.split(":"),a=Buffer.from(i,"hex"),o=await new Promise((h,d)=>{Re(e,s,64,(y,w)=>{y?d(y):h(w)})});return Lt(a,o)}async setUserPassword(e,r){if(r.length<t.MIN_PASSWORD_LENGTH)throw new Error(`Password must be at least ${t.MIN_PASSWORD_LENGTH} characters`);let s=await this.getUserById(e);if(!s)throw new Error("User not found");let i=await this.hashPassword(r);await this.db.createUser({...s,passwordHash:i})}async verifyUserPassword(e,r){let s=await this.getUserByEmail(e);if(!s||!s.passwordHash)throw new Error("Invalid credentials");if(!await this.verifyPasswordHash(r,s.passwordHash))throw new Error("Invalid credentials");return s}static sanitizeUser(e){let{passwordHash:r,...s}=e;return s}async createChannel(e,r){if(await this.db.getChannelByName(e))throw new Error(`Channel with name "${e}" already exists`);let i={id:this.id.custom(M),name:e,createdAt:Date.now(),createdBy:r};return await this.db.createChannel(i),this.emitEvent({type:"NEW_CHANNEL",payload:i}),i}async updateChannel(e,r,s){let i=await this.db.getChannelById(e);if(!i)throw new Error("Channel not found");let a=await this.getUserById(s);if(!a)throw new Error("User not found");if(i.createdBy!==s&&!a.isAdmin)throw new Error("You can only edit channels you created");if(i.name===this.generalChannelName)throw new Error(`The ${this.generalChannelName} channel cannot be renamed`);let o=await this.db.getChannelByName(r);if(o&&o.id!==e)throw new Error(`Channel with name "${r}" already exists`);return i.name=r,i.updatedAt=Date.now(),await this.db.updateChannel(i),this.emitEvent({type:"UPDATE_CHANNEL",payload:i}),i}async deleteChannel(e,r){let s=await this.db.getChannelById(e);if(!s)throw new Error("Channel not found");let i=await this.getUserById(r);if(!i)throw new Error("User not found");if(s.createdBy!==r&&!i.isAdmin)throw new Error("You can only delete channels you created");if(s.name.toLowerCase()===this.generalChannelName.toLowerCase())throw new Error("The General channel cannot be deleted");let a=await this.db.listMessagesByChannel(e);for(let h of a)await this.db.deleteMessage(h.id);let o=await this.db.listWebhooksByChannel(e);for(let h of o)await this.db.deleteWebhook(h.id);await this.db.deleteChannel(e),this.emitEvent({type:"DELETE_CHANNEL",payload:{id:e,name:s.name}})}async listChannels(){return await this.db.listChannels()}async createMessage(e,r,s,i=[]){let a=await this.getUserById(r);if(!a)throw new Error("Author not found");if(!await this.db.getChannelById(s))throw new Error("Channel not found");let h=Date.now(),d={id:this.id.custom(M),author:{id:r,userName:a.userName},images:i,content:e,channelId:s,createdAt:h,updatedAt:h,reactions:{}};return await this.db.createMessage(d),this.emitEvent({type:"NEW_MESSAGE",payload:d}),d}async updateMessage(e,r,s,i){let a=await this.getMessageById(e);if(!a)throw new Error("Message not found");if(a.author.id!==r)throw new Error("You can only edit your own messages");let o=[];return s&&(a.content=s),i&&(o=(a.images||[]).filter(d=>!i.includes(d)),a.images=i),a.updatedAt=Date.now(),await this.db.updateMessage(a),this.emitEvent({type:"UPDATE_MESSAGE",payload:a}),{message:a,removedImages:o}}async deleteMessage(e,r){let s=await this.getMessageById(e);if(!s)throw new Error("Message not found");let i=await this.getUserById(r);if(!i)throw new Error("User not found");if(s.author.id!==r&&!i.isAdmin)throw new Error("You can only delete your own messages");if(s.threadMeta&&s.threadMeta.replyCount>0){let a=await this.db.listMessagesByThread(e);for(let o of a)await this.db.deleteMessage(o.id)}await this.db.deleteMessage(e),this.emitEvent({type:"DELETE_MESSAGE",payload:{id:e,channelId:s.channelId}})}async getMessagesByChannel(e,r){return await this.db.listMessagesByChannel(e,r)}async addReaction(e,r,s){if(!await this.getUserById(r))throw new Error("User not found");if(!await this.getMessageById(e))throw new Error("Message not found");let o=await this.db.addReaction(e,r,s);if(!o)throw new Error("Failed to add reaction");return this.emitEvent({type:"NEW_REACTION",payload:{messageId:e,userId:r,reaction:s}}),o}async removeReaction(e,r,s){if(!await this.getUserById(r))throw new Error("User not found");if(!await this.getMessageById(e))throw new Error("Message not found");let o=await this.db.removeReaction(e,r,s);if(!o)throw new Error("Failed to remove reaction");return this.emitEvent({type:"DELETE_REACTION",payload:{messageId:e,userId:r,reaction:s}}),o}async getOrCreateConversation(e,r){if(e===r)throw new Error("Cannot create a conversation with yourself");if(!await this.getUserById(e))throw new Error("User not found");if(!await this.getUserById(r))throw new Error("Target user not found");let a=await this.db.getConversationByParticipants(e,r);if(a)return{conversation:a,isNew:!1};let h={id:j.generateConversationId(e,r),participants:[e,r].sort(),createdAt:Date.now()};return await this.db.createConversation(h),this.emitEvent({type:"NEW_CONVERSATION",payload:h}),{conversation:h,isNew:!0}}async getConversationById(e){return await this.db.getConversationById(e)}async listConversationsForUser(e){return await this.db.listConversationsForUser(e)}async createDirectMessage(e,r,s,i=[]){let a=await this.getUserById(r);if(!a)throw new Error("Author not found");let o=await this.getConversationById(s);if(!o)throw new Error("Conversation not found");if(!o.participants.includes(r))throw new Error("You are not a participant in this conversation");let h=Date.now(),d={id:this.id.custom(M),author:{id:r,userName:a.userName},images:i,content:e,channelId:s,createdAt:h,updatedAt:h,reactions:{}};return await this.db.createMessage(d),o.lastMessageAt=h,o.updatedAt=h,await this.db.updateConversation(o),this.emitEvent({type:"NEW_DM_MESSAGE",payload:{...d,participants:o.participants}}),d}async getMessagesByConversation(e,r){return await this.db.listMessagesByConversation(e,r)}async updateDirectMessage(e,r,s,i){let a=await this.getMessageById(e);if(!a)throw new Error("Message not found");if(!a.channelId.startsWith("dm:"))throw new Error("Message is not a direct message");if(a.author.id!==r)throw new Error("You can only edit your own messages");let o=[];s&&(a.content=s),i&&(o=(a.images||[]).filter(w=>!i.includes(w)),a.images=i),a.updatedAt=Date.now(),await this.db.updateMessage(a);let d=(await this.getConversationById(a.channelId))?.participants||[r,""];return this.emitEvent({type:"UPDATE_DM_MESSAGE",payload:{...a,participants:d}}),{message:a,removedImages:o}}async deleteDirectMessage(e,r){let s=await this.getMessageById(e);if(!s)throw new Error("Message not found");if(!s.channelId.startsWith("dm:"))throw new Error("Message is not a direct message");if(s.author.id!==r)throw new Error("You can only delete your own messages");let a=(await this.getConversationById(s.channelId))?.participants||[r,""];await this.db.deleteMessage(e),this.emitEvent({type:"DELETE_DM_MESSAGE",payload:{id:e,conversationId:s.channelId,participants:a}})}async createThreadReply(e,r,s,i=[]){let a=await this.getUserById(r);if(!a)throw new Error("Author not found");let o=await this.getMessageById(s);if(!o)throw new Error("Parent message not found");if(o.threadId)throw new Error("Cannot create a thread on a thread reply");let h=Date.now(),d={id:this.id.custom(M),author:{id:r,userName:a.userName},images:i,content:e,channelId:o.channelId,threadId:s,createdAt:h,updatedAt:h,reactions:{}};await this.db.createMessage(d);let y=await this.db.listMessagesByThread(s),w=[...new Set(y.map(f=>f.author.id))];return o.threadMeta={replyCount:y.length,lastReplyAt:h,lastReplyBy:{id:r,userName:a.userName},participants:w},o.updatedAt=h,await this.db.updateMessage(o),this.emitEvent({type:"NEW_THREAD_REPLY",payload:{parentMessageId:s,channelId:o.channelId,reply:d,threadMeta:o.threadMeta}}),{reply:d,parentMessage:o}}async getThreadReplies(e,r){return await this.db.listMessagesByThread(e,r)}async updateThreadReply(e,r,s,i){let a=await this.getMessageById(e);if(!a)throw new Error("Message not found");if(!a.threadId)throw new Error("Message is not a thread reply");if(a.author.id!==r)throw new Error("You can only edit your own messages");let o=[];return s&&(a.content=s),i&&(o=(a.images||[]).filter(d=>!i.includes(d)),a.images=i),a.updatedAt=Date.now(),await this.db.updateMessage(a),this.emitEvent({type:"UPDATE_THREAD_REPLY",payload:a}),{message:a,removedImages:o}}async deleteThreadReply(e,r){let s=await this.getMessageById(e);if(!s)throw new Error("Message not found");if(!s.threadId)throw new Error("Message is not a thread reply");let i=await this.getUserById(r);if(!i)throw new Error("User not found");if(s.author.id!==r&&!i.isAdmin)throw new Error("You can only delete your own messages");let a=s.threadId;await this.db.deleteMessage(e);let o=await this.getMessageById(a),h=null;if(o){let d=await this.db.listMessagesByThread(a);if(d.length===0)delete o.threadMeta;else{let y=d[d.length-1],w=[...new Set(d.map(f=>f.author.id))];o.threadMeta={replyCount:d.length,lastReplyAt:y.createdAt,lastReplyBy:y.author,participants:w}}o.updatedAt=Date.now(),await this.db.updateMessage(o),h=o.threadMeta||null}this.emitEvent({type:"DELETE_THREAD_REPLY",payload:{id:e,threadId:a,channelId:s.channelId,threadMeta:h}})}async createWebhook(e,r,s){let i=await this.getUserById(s);if(!i)throw new Error("User not found");if(!i.isAdmin)throw new Error("Only administrators can create webhooks");if(!await this.db.getChannelById(r))throw new Error("Channel not found");let o={id:this.id.custom(M),name:e,channelId:r,token:Be(32).toString("hex"),createdAt:Date.now(),createdBy:s};return await this.db.createWebhook(o),this.emitEvent({type:"NEW_WEBHOOK",payload:{id:o.id,name:o.name,channelId:o.channelId}}),o}async deleteWebhook(e,r){let s=await this.getUserById(r);if(!s)throw new Error("User not found");if(!s.isAdmin)throw new Error("Only administrators can delete webhooks");let i=await this.db.getWebhookById(e);if(!i)throw new Error("Webhook not found");await this.db.deleteWebhook(e),this.emitEvent({type:"DELETE_WEBHOOK",payload:{id:e,channelId:i.channelId}})}async listWebhooks(e){let r=await this.getUserById(e);if(!r)throw new Error("User not found");if(!r.isAdmin)throw new Error("Only administrators can list webhooks");return await this.db.listWebhooks()}async getWebhookById(e){return await this.db.getWebhookById(e)}async getWebhookByToken(e){return await this.db.getWebhookByToken(e)}async createWebhookMessage(e,r){if(!await this.db.getChannelById(r.channelId))throw new Error("Channel not found");let i=Date.now(),a={id:this.id.custom(M),author:{id:`webhook:${r.id}`,userName:r.name,isBot:!0},content:e,channelId:r.channelId,createdAt:i,updatedAt:i,reactions:{}};return await this.db.createMessage(a),this.emitEvent({type:"NEW_MESSAGE",payload:a}),a}emitEvent(e){console.log(`Emitting event ${e.type}`,e.payload),this.eventEmitter.emit("sse",e)}subscribeToEvents(e){let r=s=>e(s);return this.eventEmitter.on("sse",r),()=>this.eventEmitter.off("sse",r)}};import{randomBytes as te}from"node:crypto";import{existsSync as P,mkdirSync as ye,readFileSync as We,unlinkSync as Fe,writeFileSync as re}from"node:fs";import{join as U}from"node:path";var Oe=class{requests=new Map;limit;windowMs;constructor(t=100,e=60){this.limit=t,this.windowMs=e*1e3,setInterval(()=>this.cleanup(),this.windowMs)}getLimit(){return this.limit}isAllowed(t){let e=Date.now(),r=t||"unknown",s=this.requests.get(r);return(!s||s.resetTime<e)&&(s={count:0,resetTime:e+this.windowMs},this.requests.set(r,s)),s.count++,s.count<=this.limit}getRemainingRequests(t){let e=Date.now(),r=t||"unknown",s=this.requests.get(r);return!s||s.resetTime<e?this.limit:Math.max(0,this.limit-s.count)}getResetTime(t){let e=Date.now(),r=t||"unknown",s=this.requests.get(r);return!s||s.resetTime<e?Math.floor((e+this.windowMs)/1e3):Math.floor(s.resetTime/1e3)}cleanup(){let t=Date.now();for(let[e,r]of this.requests.entries())r.resetTime<t&&this.requests.delete(e)}};import{URL as Bt}from"url";var Ne=class{routes=[];globalMiddlewares=[];pathPatterns=new Map;use(t){return this.globalMiddlewares.push(t),this}get(t,...e){let r=e.pop();return this.register("GET",t,r,e)}post(t,...e){let r=e.pop();return this.register("POST",t,r,e)}put(t,...e){let r=e.pop();return this.register("PUT",t,r,e)}delete(t,...e){let r=e.pop();return this.register("DELETE",t,r,e)}patch(t,...e){let r=e.pop();return this.register("PATCH",t,r,e)}any(t,...e){let r=e.pop(),s=e;return this.register("GET",t,r,s),this.register("POST",t,r,s),this.register("PUT",t,r,s),this.register("DELETE",t,r,s),this.register("PATCH",t,r,s),this.register("OPTIONS",t,r,s),this}options(t,...e){let r=e.pop();return this.register("OPTIONS",t,r,e)}match(t,e){for(let r of this.routes){if(r.method!==t)continue;let s=this.pathPatterns.get(r.path);if(!s)continue;let i=s.pattern.exec(e);if(!i)continue;let a={};return s.paramNames.forEach((o,h)=>{a[o]=i[h+1]||""}),{route:r,params:a}}return null}async handle(t,e){let r=t.method||"GET",s=new Bt(t.url||"/",`http://${t.headers.host}`),i=s.pathname,a=this.match(r,i);if(!a)return null;let{route:o,params:h}=a,d={};s.searchParams.forEach((f,n)=>{d[n]=f});let y={req:t,res:e,params:h,query:d,body:t.body||{},headers:t.headers,path:i,state:{},raw:()=>e,binary:(f,n="application/octet-stream",u=200)=>({statusCode:u,body:f,headers:{"Content-Type":n,"Content-Length":f.length.toString()},isRaw:!0}),text:(f,n=200)=>({statusCode:n,body:f,headers:{"Content-Type":"text/plain"}}),form:(f,n=200)=>({statusCode:n,body:f,headers:{"Content-Type":"application/x-www-form-urlencoded"}}),json:(f,n=200)=>({statusCode:n,body:f,headers:{"Content-Type":"application/json"}}),html:(f,n=200)=>({statusCode:n,body:f,headers:{"Content-Type":"text/html"}}),redirect:(f,n=302)=>({statusCode:n,body:null,headers:{Location:f}}),status:function(f){return{raw:()=>e,binary:(n,u="application/octet-stream")=>({statusCode:f,body:n,headers:{"Content-Type":u,"Content-Length":n.length.toString()},isRaw:!0}),text:n=>({statusCode:f,body:n,headers:{"Content-Type":"text/plain"}}),json:n=>({statusCode:f,body:n,headers:{"Content-Type":"application/json"}}),html:n=>({statusCode:f,body:n,headers:{"Content-Type":"text/html"}}),form:n=>({statusCode:f,body:n,headers:{"Content-Type":"application/x-www-form-urlencoded"}}),redirect:(n,u=302)=>({statusCode:u,body:null,headers:{Location:n}}),status:n=>this.status(n)}}},w=[...this.globalMiddlewares,...o.middlewares];return this.executeMiddlewareChain(y,w,o.handler)}register(t,e,r,s=[]){return this.routes.push({method:t,path:e,handler:r,middlewares:s}),this.pathPatterns.set(e,this.createPathPattern(e)),this}createPathPattern(t){let e=[],r=t.replace(/\/:[^/]+/g,s=>{let i=s.slice(2);return e.push(i),"/([^/]+)"});return r.endsWith("/*")?(r=`${r.slice(0,-2)}(?:/(.*))?`,e.push("wildcard")):r=r.replace(/\/$/,"/?"),{pattern:new RegExp(`^${r}$`),paramNames:e}}async executeMiddlewareChain(t,e,r){let s=0,i=async()=>{if(s<e.length){let a=e[s++];return a(t,i)}return r(t)};return i()}};var Z=()=>({port:Number(process.env.PORT)||3e3,host:process.env.HOST||"0.0.0.0",useHttps:!1,useHttp2:!1,sslCert:"",sslKey:"",sslCa:"",debug:Rt(process.env.DEBUG)||!1,maxBodySize:1048576,requestTimeout:3e4,rateLimit:{enabled:!0,requestsPerMinute:100},allowedDomains:["*"]});function Rt(t){return t==="true"||t===!0}var I=Z(),He=t=>({configFilePath:"mikroserve.config.json",args:process.argv,options:[{flag:"--port",path:"port",defaultValue:I.port},{flag:"--host",path:"host",defaultValue:I.host},{flag:"--https",path:"useHttps",defaultValue:I.useHttps,isFlag:!0},{flag:"--http2",path:"useHttp2",defaultValue:I.useHttp2,isFlag:!0},{flag:"--cert",path:"sslCert",defaultValue:I.sslCert},{flag:"--key",path:"sslKey",defaultValue:I.sslKey},{flag:"--ca",path:"sslCa",defaultValue:I.sslCa},{flag:"--ratelimit",path:"rateLimit.enabled",defaultValue:I.rateLimit.enabled,isFlag:!0},{flag:"--rps",path:"rateLimit.requestsPerMinute",defaultValue:I.rateLimit.requestsPerMinute},{flag:"--allowed",path:"allowedDomains",defaultValue:I.allowedDomains,parser:D.array},{flag:"--debug",path:"debug",defaultValue:I.debug,isFlag:!0},{flag:"--max-body-size",path:"maxBodySize",defaultValue:I.maxBodySize},{flag:"--request-timeout",path:"requestTimeout",defaultValue:I.requestTimeout}],config:t});function _e(t,e){let r=e.match(/boundary=(?:"([^"]+)"|([^;]+))/i);if(!r)throw new Error("Invalid multipart/form-data: missing boundary");let s=r[1]||r[2],i=Buffer.from(`--${s}`),a=Buffer.from(`--${s}--`),o={},h={},d=Ot(t,i);for(let y of d){if(y.length===0||y.equals(a.subarray(i.length)))continue;let w=Nt(y);if(!w)continue;let{name:f,filename:n,contentType:u,data:l}=w;if(n){let c={filename:n,contentType:u||"application/octet-stream",data:l,size:l.length};h[f]?Array.isArray(h[f])?h[f].push(c):h[f]=[h[f],c]:h[f]=c}else{let c=l.toString("utf8");o[f]?Array.isArray(o[f])?o[f].push(c):o[f]=[o[f],c]:o[f]=c}}return{fields:o,files:h}}function Ot(t,e){let r=[],s=0;for(;s<t.length;){let i=t.indexOf(e,s);if(i===-1)break;s!==i&&r.push(t.subarray(s,i)),s=i+e.length,s<t.length&&t[s]===13&&t[s+1]===10&&(s+=2)}return r}function Nt(t){let e=Buffer.from(`\r
\r
`),r=t.indexOf(e);if(r===-1)return null;let s=t.subarray(0,r),i=t.subarray(r+4),o=s.toString("utf8").split(`\r
`),h="",d="",y,w;for(let n of o){let u=n.toLowerCase();if(u.startsWith("content-disposition:")){h=n.substring(20).trim();let l=h.match(/name="([^"]+)"/);l&&(d=l[1]);let c=h.match(/filename="([^"]+)"/);c&&(y=c[1])}else u.startsWith("content-type:")&&(w=n.substring(13).trim())}if(!d)return null;let f=i;return f.length>=2&&f[f.length-2]===13&&f[f.length-1]===10&&(f=f.subarray(0,f.length-2)),{disposition:h,name:d,filename:y,contentType:w,data:f}}import{readFileSync as _}from"fs";import fe from"http";import Ht from"http2";import _t from"https";var pe=class{config;rateLimiter;router;shutdownHandlers=[];constructor(t){let e=new L(He(t||{})).get();e.debug&&console.log("Using configuration:",e),this.config=e,this.router=new Ne;let r=e.rateLimit.requestsPerMinute||Z().rateLimit.requestsPerMinute;this.rateLimiter=new Oe(r,60),e.rateLimit.enabled===!0&&this.use(this.rateLimitMiddleware.bind(this))}use(t){return this.router.use(t),this}get(t,...e){return this.router.get(t,...e),this}post(t,...e){return this.router.post(t,...e),this}put(t,...e){return this.router.put(t,...e),this}delete(t,...e){return this.router.delete(t,...e),this}patch(t,...e){return this.router.patch(t,...e),this}any(t,...e){return this.router.any(t,...e),this}options(t,...e){return this.router.options(t,...e),this}start(){let t=this.createServer(),{port:e,host:r}=this.config;return this.setupGracefulShutdown(t),t.listen(e,r,()=>{let s=t.address(),i=this.config.useHttps||this.config.useHttp2?"https":"http";console.log(`MikroServe running at ${i}://${s.address!=="::"?s.address:"localhost"}:${s.port}`)}),t}createServer(){let t=this.requestHandler.bind(this);if(this.config.useHttp2){if(!this.config.sslCert||!this.config.sslKey)throw new Error("SSL certificate and key paths are required when useHttp2 is true");try{let e={key:_(this.config.sslKey),cert:_(this.config.sslCert),...this.config.sslCa?{ca:_(this.config.sslCa)}:{}};return Ht.createSecureServer(e,t)}catch(e){throw e.message.includes("key values mismatch")?new Error(`SSL certificate and key do not match: ${e.message}`):e}}else if(this.config.useHttps){if(!this.config.sslCert||!this.config.sslKey)throw new Error("SSL certificate and key paths are required when useHttps is true");try{let e={key:_(this.config.sslKey),cert:_(this.config.sslCert),...this.config.sslCa?{ca:_(this.config.sslCa)}:{}};return _t.createServer(e,t)}catch(e){throw e.message.includes("key values mismatch")?new Error(`SSL certificate and key do not match: ${e.message}`):e}}return fe.createServer(t)}async rateLimitMiddleware(t,e){let r=t.req.socket.remoteAddress||"unknown";return t.res.setHeader("X-RateLimit-Limit",this.rateLimiter.getLimit().toString()),t.res.setHeader("X-RateLimit-Remaining",this.rateLimiter.getRemainingRequests(r).toString()),t.res.setHeader("X-RateLimit-Reset",this.rateLimiter.getResetTime(r).toString()),this.rateLimiter.isAllowed(r)?e():{statusCode:429,body:{error:"Too Many Requests",message:"Rate limit exceeded, please try again later"},headers:{"Content-Type":"application/json"}}}async requestHandler(t,e){let r=Date.now(),s=t.method||"UNKNOWN",i=t.url||"/unknown",a=this.config.debug;try{if(this.setCorsHeaders(e,t),this.setSecurityHeaders(e,this.config.useHttps),a&&console.log(`${s} ${i}`),t.method==="OPTIONS"){if(e instanceof fe.ServerResponse)e.statusCode=204,e.end();else{let h=e;h.writeHead(204),h.end()}return}try{t.body=await this.parseBody(t)}catch(h){return a&&console.error("Body parsing error:",h.message),this.respond(e,{statusCode:400,body:{error:"Bad Request",message:h.message}})}let o=await this.router.handle(t,e);return o?o._handled?void 0:this.respond(e,o):this.respond(e,{statusCode:404,body:{error:"Not Found",message:"The requested endpoint does not exist"}})}catch(o){return console.error("Server error:",o),this.respond(e,{statusCode:500,body:{error:"Internal Server Error",message:a?o.message:"An unexpected error occurred"}})}finally{a&&this.logDuration(r,s,i)}}logDuration(t,e,r){let s=Date.now()-t;console.log(`${e} ${r} completed in ${s}ms`)}async parseBody(t){return new Promise((e,r)=>{let s=[],i=0,a=this.config.maxBodySize,o=!1,h=null,d=this.config.debug,y=t.headers["content-type"]||"";d&&console.log("Content-Type:",y),this.config.requestTimeout>0&&(h=setTimeout(()=>{o||(o=!0,d&&console.log("Request timeout exceeded"),r(new Error("Request timeout")))},this.config.requestTimeout));let w=()=>{h&&(clearTimeout(h),h=null)};t.on("data",f=>{if(!o){if(i+=f.length,d&&console.log(`Received chunk: ${f.length} bytes, total size: ${i}`),i>a){o=!0,w(),d&&console.log(`Body size exceeded limit: ${i} > ${a}`),r(new Error("Request body too large"));return}s.push(f)}}),t.on("end",()=>{if(!o){o=!0,w(),d&&console.log(`Request body complete: ${i} bytes`);try{if(s.length>0){let f=Buffer.concat(s);if(y.includes("application/json"))try{let n=f.toString("utf8");e(JSON.parse(n))}catch(n){r(new Error(`Invalid JSON in request body: ${n.message}`))}else if(y.includes("application/x-www-form-urlencoded")){let n=f.toString("utf8"),u={};new URLSearchParams(n).forEach((l,c)=>{u[c]=l}),e(u)}else if(y.includes("multipart/form-data"))try{let n=_e(f,y);e(n)}catch(n){r(new Error(`Invalid multipart form data: ${n.message}`))}else this.isBinaryContentType(y)?e(f):e(f.toString("utf8"))}else e({})}catch(f){r(new Error(`Invalid request body: ${f}`))}}}),t.on("error",f=>{o||(o=!0,w(),r(new Error(`Error reading request body: ${f.message}`)))}),t.on("close",()=>{w()})})}isBinaryContentType(t){return["application/octet-stream","application/pdf","application/zip","application/gzip","application/x-tar","application/x-rar-compressed","application/x-7z-compressed","image/","video/","audio/","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument","application/msword","application/vnd.ms-powerpoint"].some(r=>t.includes(r))}setCorsHeaders(t,e){let r=e.headers.origin,{allowedDomains:s=["*"]}=this.config;!r||s.length===0||s.includes("*")?t.setHeader("Access-Control-Allow-Origin","*"):s.includes(r)&&(t.setHeader("Access-Control-Allow-Origin",r),t.setHeader("Vary","Origin")),t.setHeader("Access-Control-Allow-Methods","GET, POST, PUT, DELETE, PATCH, OPTIONS"),t.setHeader("Access-Control-Allow-Headers","Content-Type, Authorization"),t.setHeader("Access-Control-Max-Age","86400")}setSecurityHeaders(t,e=!1){let r={"X-Content-Type-Options":"nosniff","X-Frame-Options":"DENY","Content-Security-Policy":"default-src 'self'; script-src 'self'; object-src 'none'","X-XSS-Protection":"1; mode=block"};if((e||this.config.useHttp2)&&(r["Strict-Transport-Security"]="max-age=31536000; includeSubDomains"),t instanceof fe.ServerResponse)Object.entries(r).forEach(([s,i])=>{t.setHeader(s,i)});else{let s=t;Object.entries(r).forEach(([i,a])=>{s.setHeader(i,a)})}}respond(t,e){let r={...e.headers||{}};(i=>typeof i.writeHead=="function"&&typeof i.end=="function")(t)?(t.writeHead(e.statusCode,r),e.body===null||e.body===void 0?t.end():e.isRaw||typeof e.body=="string"?t.end(e.body):t.end(JSON.stringify(e.body))):(console.warn("Unexpected response object type without writeHead/end methods"),t.writeHead?.(e.statusCode,r),e.body===null||e.body===void 0?t.end?.():e.isRaw||typeof e.body=="string"?t.end?.(e.body):t.end?.(JSON.stringify(e.body)))}setupGracefulShutdown(t){let e=o=>{console.log("Shutting down MikroServe server..."),o&&console.error("Error:",o),this.cleanupShutdownHandlers(),t.close(()=>{console.log("Server closed successfully"),process.env.NODE_ENV!=="test"&&process.env.VITEST!=="true"&&setImmediate(()=>process.exit(o?1:0))})},r=()=>e(),s=()=>e(),i=o=>e(o),a=o=>e(o);this.shutdownHandlers=[r,s,i,a],process.on("SIGINT",r),process.on("SIGTERM",s),process.on("uncaughtException",i),process.on("unhandledRejection",a)}cleanupShutdownHandlers(){if(this.shutdownHandlers.length>0){let[t,e,r,s]=this.shutdownHandlers;process.removeListener("SIGINT",t),process.removeListener("SIGTERM",e),process.removeListener("uncaughtException",r),process.removeListener("unhandledRejection",s),this.shutdownHandlers=[]}}};var Q=class{constructor(e,r){this.config=e;this.mikroAuth=r}getAuthorizationUrl(e){let r=Array.isArray(this.config.scopes)?this.config.scopes.join(" "):this.config.scopes,s=new URLSearchParams({client_id:this.config.clientId,redirect_uri:this.config.redirectUri,response_type:"code",scope:r,state:e,...this.config.authorizationParams});return`${this.config.authorizationUrl}?${s}`}async exchangeCodeForTokens(e){let r=new URLSearchParams({client_id:this.config.clientId,client_secret:this.config.clientSecret,code:e,grant_type:"authorization_code",redirect_uri:this.config.redirectUri}),s=await fetch(this.config.tokenUrl,{method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded",Accept:"application/json",...this.config.tokenHeaders},body:r.toString()});if(!s.ok){let i=await s.text();throw new Error(`Token exchange failed: ${s.status} ${s.statusText} - ${i}`)}return s.json()}async fetchUserInfo(e){let r=await fetch(this.config.userInfoUrl,{headers:{Authorization:`Bearer ${e}`,Accept:"application/json",...this.config.userInfoHeaders}});if(!r.ok){let s=await r.text();throw new Error(`User info fetch failed: ${r.status} ${r.statusText} - ${s}`)}return r.json()}mapUserInfo(e){return this.config.userMapping?this.config.userMapping(e):{id:e.sub||e.id?.toString(),email:e.email,name:e.name||e.preferred_username,username:e.preferred_username||e.username||e.email?.split("@")[0]}}async handleCallback(e,r){let s=await this.exchangeCodeForTokens(e),i=await this.fetchUserInfo(s.access_token),a=this.mapUserInfo(i);if(!a.email)throw new Error("OAuth provider did not return user email");let o=await this.mikroAuth.createToken({email:a.email,username:a.username||a.name,role:"user",ip:r});return{accessToken:o.accessToken,refreshToken:o.refreshToken,expiresIn:o.exp,tokenType:o.tokenType,user:a}}getPublicInfo(){return{id:this.config.id,name:this.config.name,loginUrl:`/auth/oauth/${this.config.id}`}}};import{randomBytes as Vt}from"node:crypto";var zt=600,Wt=10,Ft=9e5,qt=6e4,ee=class{states=new Map;rateLimits=new Map;stateExpiryMs;maxAttempts;windowMs;cleanupTimer;constructor(e){this.stateExpiryMs=(e.stateExpirySeconds||zt)*1e3,this.maxAttempts=e.rateLimiting?.maxAttempts||Wt,this.windowMs=e.rateLimiting?.windowMs||Ft,this.cleanupTimer=setInterval(()=>this.cleanup(),qt),this.cleanupTimer.unref()}generateState(e,r){let s=Vt(32).toString("hex");return this.states.set(s,{expires:Date.now()+this.stateExpiryMs,providerId:r,ip:e}),s}validateState(e,r,s){let i=this.states.get(e);return i?(this.states.delete(e),Date.now()>i.expires?{valid:!1,error:"State token expired"}:i.providerId!==s?{valid:!1,error:"Provider mismatch"}:i.ip!==r?{valid:!1,error:"IP address mismatch"}:{valid:!0}):{valid:!1,error:"Invalid or expired state"}}checkRateLimit(e){let r=Date.now(),s=this.rateLimits.get(e);return!s||r>s.resetAt?(this.rateLimits.set(e,{count:1,resetAt:r+this.windowMs}),!0):(s.count++,s.count<=this.maxAttempts)}getRateLimitInfo(e){let r=this.rateLimits.get(e);return r?{remaining:Math.max(0,this.maxAttempts-r.count),reset:r.resetAt}:{remaining:this.maxAttempts,reset:Date.now()+this.windowMs}}cleanup(){let e=Date.now();for(let[r,s]of this.states)e>s.expires&&this.states.delete(r);for(let[r,s]of this.rateLimits)e>s.resetAt&&this.rateLimits.delete(r)}destroy(){clearInterval(this.cleanupTimer)}};var Ve={google:{id:"google",name:"Google",authorizationUrl:"https://accounts.google.com/o/oauth2/v2/auth",tokenUrl:"https://oauth2.googleapis.com/token",userInfoUrl:"https://www.googleapis.com/oauth2/v2/userinfo",scopes:"openid email profile",authorizationParams:{access_type:"offline",prompt:"consent"},userMapping:t=>({id:t.sub,email:t.email,name:t.name,username:t.email.split("@")[0]})},github:{id:"github",name:"GitHub",authorizationUrl:"https://github.com/login/oauth/authorize",tokenUrl:"https://github.com/login/oauth/access_token",userInfoUrl:"https://api.github.com/user",scopes:"user:email read:user",tokenHeaders:{Accept:"application/json"},userInfoHeaders:{Accept:"application/vnd.github.v3+json"},userMapping:t=>({id:t.id.toString(),email:t.email,name:t.name||t.login,username:t.login})},microsoft:{id:"microsoft",name:"Microsoft",authorizationUrl:"https://login.microsoftonline.com/common/oauth2/v2.0/authorize",tokenUrl:"https://login.microsoftonline.com/common/oauth2/v2.0/token",userInfoUrl:"https://graph.microsoft.com/v1.0/me",scopes:"openid email profile User.Read",userMapping:t=>({id:t.id,email:t.mail||t.userPrincipalName,name:t.displayName,username:t.userPrincipalName?.split("@")[0]})},gitlab:{id:"gitlab",name:"GitLab",authorizationUrl:"https://gitlab.com/oauth/authorize",tokenUrl:"https://gitlab.com/oauth/token",userInfoUrl:"https://gitlab.com/api/v4/user",scopes:"read_user email",userMapping:t=>({id:t.id.toString(),email:t.email,name:t.name,username:t.username})}};function ze(t){let e=[];if(t.presets)for(let[r,s]of Object.entries(t.presets)){let i=Ve[r];if(!i){console.warn(`[OAuth] Unknown preset provider: ${r}`);continue}e.push({...i,clientId:s.clientId,clientSecret:s.clientSecret,redirectUri:s.redirectUri,scopes:s.scopes||i.scopes,authorizationParams:{...i.authorizationParams,...s.authorizationParams}})}return t.custom&&e.push(...t.custom),e}var we=50,be=10,ve=["jpg","jpeg","png","webp","svg"],Kt=3,Gt=60*1e3,V=new Map,O=new Map;async function qe(t){let{config:e,auth:r,chat:s,isInviteRequired:i,hasEmailConfig:a,authMode:o,appUrl:h}=t,d=new pe(e);async function y(n){let u=[...new Set(n.filter(c=>!c.author.isBot).map(c=>c.author.id))],l=new Map;return await Promise.all(u.map(async c=>{let m=await s.getUserById(c);m&&l.set(c,m)})),n.map(c=>{if(c.author.isBot)return c;let m=l.get(c.author.id);return{...c,author:{id:m?.id||c.author.id,userName:m?.userName||"Unknown User"}}})}o==="dev"&&d.post("/auth/dev-login",async n=>{if(!n.body.email)return n.json({error:"Email is required"},400);let{email:u}=n.body,l=await s.getUserByEmail(u);if(i&&!l)return n.json({success:!1,message:"Unauthorized"},401);l||(l=await s.addUser(u,u,!1,!0));let c=r.generateJsonWebToken({id:l.id,username:l.userName,email:l.email,role:l.isAdmin?"admin":"user"});return n.json({user:l,token:c},200)}),o==="magic-link"&&(d.post("/auth/login",async n=>{if(!n.body.email)return n.json({error:"Email is required"},400);let{email:u}=n.body,l="If a matching account was found, a magic link has been sent.";async function c(){let m=await r.createMagicLink({email:u});if(!m)return n.json({error:"Failed to create magic link"},400);l=m.message}return i?await s.getUserByEmail(u)&&await c():await c(),n.json({success:!0,message:l},200)}),d.post("/auth/verify",async n=>{let u=n.body,c=(n.headers.authorization||"").split(" ")[1];if(!c)return n.json({error:"Token is required"},400);try{let m=await r.verifyToken({email:u.email,token:c});return m?n.json(m,200):n.json({error:"Invalid token"},400)}catch{return n.json({error:"Invalid token"},400)}})),o==="password"&&(d.post("/auth/password-login",async n=>{let{email:u,password:l}=n.body;if(!u||!l)return n.json({error:"Email and password are required"},400);try{let c=await s.verifyUserPassword(u,l),m=await r.createToken({email:c.email,username:c.userName,role:c.isAdmin?"admin":"user"});return n.json(m,200)}catch{return n.json({error:"Invalid credentials"},401)}}),d.post("/auth/request-password-reset",async n=>{let{email:u}=n.body;if(!u)return n.json({error:"Email is required"},400);try{let l=await s.getUserByEmail(u);l&&await r.createMagicLink({email:u,subject:l.passwordHash?"Reset Your Password":"Set Your Password"})}catch{}return n.json({success:!0,message:"If a matching account was found, a password reset link has been sent."},200)}),d.post("/auth/setup-password",async n=>{let{email:u,password:l,token:c}=n.body,m=n.headers.authorization||"",g=c||m.split(" ")[1];if(!u||!g)return n.json({error:"Email and token are required"},400);if(!l||l.length<8)return n.json({error:"Password must be at least 8 characters"},400);try{let p=await r.verifyToken({email:u,token:g});if(!p)return n.json({error:"Invalid or expired token"},400);let v=await s.getUserByEmail(u);return v?(await s.setUserPassword(v.id,l),n.json(p,200)):n.json({error:"User not found"},404)}catch{return n.json({error:"Invalid or expired token"},400)}}),i||d.post("/auth/register",async n=>{let{email:u,password:l}=n.body;if(!u)return n.json({error:"Email is required"},400);if(!l||l.length<8)return n.json({error:"Password must be at least 8 characters"},400);try{if(await s.getUserByEmail(u))return n.json({error:"User already exists"},400);let m=await s.addUser(u,u,!1,!0);await s.setUserPassword(m.id,l);let g=await r.createToken({email:m.email,username:m.userName,role:"user"});return n.json(g,200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}));let{oauth:w}=t;if(w){let n=new ee(w),u=new Map,l=ze(w);for(let c of l){let m=new Q(c,r);u.set(c.id,m)}if(u.size>0){d.get("/auth/oauth/providers",async c=>{let m=Array.from(u.values()).map(g=>g.getPublicInfo());return c.json({providers:m,count:m.length})});for(let[c,m]of u.entries())d.get(`/auth/oauth/${c}`,async g=>{try{let p=g.headers["x-forwarded-for"],v=g.headers["x-real-ip"],E=(Array.isArray(p)?p[0]:p)?.split(",")[0]?.trim()||(Array.isArray(v)?v[0]:v)||"unknown";if(!n.checkRateLimit(`oauth:${E}`)){let T=n.getRateLimitInfo(`oauth:${E}`);return g.json({error:"Too many authentication attempts. Please try again later.",retryAfter:Math.ceil((T.reset-Date.now())/1e3)},429)}let b=n.generateState(E,c),S=m.getAuthorizationUrl(b);return g.redirect(S,302)}catch(p){let v=p instanceof Error?p.message:"Error initiating OAuth flow";return g.json({error:v},500)}}),d.get(`/auth/oauth/${c}/callback`,async g=>{try{let p=g.headers["x-forwarded-for"],v=g.headers["x-real-ip"],E=(Array.isArray(p)?p[0]:p)?.split(",")[0]?.trim()||(Array.isArray(v)?v[0]:v)||"unknown";if(!n.checkRateLimit(`oauth:${E}`)){let ie=n.getRateLimitInfo(`oauth:${E}`);return g.json({error:"Too many authentication attempts. Please try again later.",retryAfter:Math.ceil((ie.reset-Date.now())/1e3)},429)}if(g.query.error){let ie=g.query.error_description||"Authentication was denied";return g.redirect(`${h}/?oauth_error=${encodeURIComponent(ie)}`,302)}let S=g.query.state,T=g.query.code;if(!S||!T)return g.redirect(`${h}/?oauth_error=${encodeURIComponent("Missing state or authorization code")}`,302);let A=n.validateState(S,E,c);if(!A.valid)return g.redirect(`${h}/?oauth_error=${encodeURIComponent(A.error||"Invalid OAuth callback")}`,302);let k=await m.handleCallback(T,E),N=await s.getUserByEmail(k.user.email);if(!N&&i)return g.redirect(`${h}/?oauth_error=${encodeURIComponent("User not found. You must be invited before signing in with OAuth.")}`,302);N||(N=await s.addUser(k.user.email,k.user.name||k.user.username||k.user.email,!1,!0));let K=new URLSearchParams({access_token:k.accessToken,refresh_token:k.refreshToken,expires_in:String(k.expiresIn)});return g.redirect(`${h}/?${K.toString()}`,302)}catch(p){let v=p instanceof Error?p.message:"OAuth authentication failed";return g.redirect(`${h}/?oauth_error=${encodeURIComponent(v)}`,302)}})}}d.post("/auth/logout",f,async n=>{let l=n.body.refreshToken;if(!l)return n.json({error:"Missing refresh token"},400);let c=await r.logout(l);return n.json(c,200)}),d.get("/auth/me",f,async n=>{let u=n.state.user;return n.json({user:u?$.sanitizeUser(u):null},200)}),d.post("/auth/refresh",async n=>{let l=n.body.refreshToken,c=await r.refreshAccessToken(l);return n.json(c,200)}),d.get("/auth/sessions",f,async n=>{let u=n.headers.authorization;if(!u||!u.startsWith("Bearer "))return n.json(null,401);let l=n.body,c=u.split(" ")[1],g={email:r.verify(c).sub},p=await r.getSessions({body:l,user:g});return n.json(p,200)}),d.delete("/auth/sessions",f,async n=>{let u=n.headers.authorization;if(!u||!u.startsWith("Bearer "))return n.json(null,401);let l=n.body,c=u.split(" ")[1],g={email:r.verify(c).sub},p=await r.revokeSessions({body:l,user:g});return n.json(p,200)}),d.post("/users/add",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let{email:l,role:c,password:m}=n.body;if(!l)return n.json({error:"Email is required"},400);try{if(c==="admin"&&!u.isAdmin)return n.json({error:"Only administrators can add admin users"},403);if(await s.getUserByEmail(l))return n.json({success:!1,message:"User already exists"});let p=await s.addUser(l,u.id,c==="admin");if(o==="password"&&m)await s.setUserPassword(p.id,m);else if(o==="password"&&a)try{await r.createMagicLink({email:l})}catch{}return n.json({success:!0,userId:p.id},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.get("/users",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);try{let l=await s.listUsers();return n.json({users:l.map($.sanitizeUser)},200)}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.delete("/users/:id",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.id;if(l===u.id)return n.json({error:"You cannot remove your own account"},400);try{return await s.removeUser(l,u.id),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/users/:id/reset-password",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);if(!u.isAdmin)return n.json({error:"Only administrators can reset passwords"},403);let l=n.params.id,{password:c}=n.body;if(!c||c.length<8)return n.json({error:"Password must be at least 8 characters"},400);try{return await s.setUserPassword(l,c),n.json({success:!0},200)}catch(m){let g=m instanceof Error?m.message:"An error occurred";return n.json({error:g},400)}}),d.post("/users/exit",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);try{return u.isAdmin&&(await s.listUsers()).filter(c=>c.isAdmin).length<=1?n.json({error:"Cannot exit as the last administrator"},400):(await s.exitUser(u.id),n.json({success:!0,message:"You have exited the server"},200))}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.put("/users/me",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);try{let{userName:l}=n.body;if(!l||typeof l!="string")return n.json({error:"userName is required"},400);let c=await s.updateUserName(u.id,l);return n.json({user:$.sanitizeUser(c)},200)}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.get("/channels",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);let l=await s.listChannels();return n.json({channels:l},200)}),d.post("/channels",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let{name:l}=n.body;if(!l)return n.json({error:"Channel name is required"},400);try{let c=await s.createChannel(l,u.id);return n.json({channel:c},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.get("/channels/:channelId/messages",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);let l=n.params.channelId,c=n.query.limit?parseInt(n.query.limit,10):we,m=n.query.before||void 0;try{let g=await s.getMessagesByChannel(l,{limit:c,before:m}),p=await y(g);return n.json({messages:p},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.post("/channels/:channelId/messages",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.channelId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let g=await s.createMessage(c,u.id,l);return n.json({message:g},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.put("/channels/:channelId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.channelId,{name:c}=n.body;if(!c)return n.json({error:"Channel name is required"},400);try{let m=await s.updateChannel(l,c,u.id);return n.json({channel:m},200)}catch(m){let g=m instanceof Error?m.message:"An error occurred";return n.json({error:g},400)}}),d.delete("/channels/:channelId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.channelId;try{return await s.deleteChannel(l,u.id),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.put("/messages/:messageId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let{message:g,removedImages:p}=await s.updateMessage(l,u.id,c,m);return z(p),n.json({message:g},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.delete("/messages/:messageId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId;try{let m=(await s.getMessageById(l))?.images||[];return await s.deleteMessage(l,u.id),z(m),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/messages/:messageId/reactions",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,{reaction:c}=n.body;if(!c)return n.json({error:"Reaction is required"},400);try{let m=await s.addReaction(l,u.id,c);return m?n.json({message:m},200):n.json({error:`Message with ID ${l} not found`},404)}catch(m){console.error(`Error adding reaction to message ${l}:`,m);let g=m instanceof Error?m.message:"An error occurred";return n.json({error:g},400)}}),d.delete("/messages/:messageId/reactions",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,{reaction:c}=n.body;if(!c)return n.json({error:"Reaction is required"},400);try{let m=await s.removeReaction(l,u.id,c);return m?n.json({message:m},200):n.json({error:`Message with ID ${l} not found`},404)}catch(m){console.error(`Error removing reaction from message ${l}:`,m);let g=m instanceof Error?m.message:"An error occurred";return n.json({error:g},400)}}),d.get("/messages/:messageId/thread",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,c=n.query.limit?parseInt(n.query.limit,10):we,m=n.query.before||void 0;try{let g=await s.getThreadReplies(l,{limit:c,before:m}),p=await y(g);return n.json({replies:p},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.post("/messages/:messageId/thread",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let{reply:g,parentMessage:p}=await s.createThreadReply(c,u.id,l,m||[]);return n.json({reply:g,threadMeta:p.threadMeta},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.put("/messages/:messageId/thread/:replyId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.replyId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let{message:g,removedImages:p}=await s.updateThreadReply(l,u.id,c,m);return z(p),n.json({message:g},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.delete("/messages/:messageId/thread/:replyId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.replyId;try{let m=(await s.getMessageById(l))?.images||[];return await s.deleteThreadReply(l,u.id),z(m),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/messages/:messageId/thread/image",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);try{let{filename:l,image:c,thumbnail:m}=n.body;if(!c)return n.json({error:"No image provided"},400);let g=l.split(".").pop();if(!g)return n.json({error:"Missing file extension"},400);if(!ve.includes(g))return n.json({error:"Unsupported file format"},400);let p=Buffer.from(c,"base64"),v=be*1024*1024;if(p.length>v)return n.json({error:"Image too large"},400);let E=`${process.cwd()}/uploads`;P(E)||ye(E);let b=`${Date.now()}-${te(16).toString("hex")}.${g}`,S=U(E,b);return re(S,p),m&&Ee(E,b,m),n.json({success:!0,filename:b})}catch(l){return console.error("Image upload error:",l),n.json({success:!1,error:l instanceof Error?l.message:"Upload failed"},500)}}),d.get("/conversations",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);try{let l=await s.listConversationsForUser(u.id),c=[...new Set(l.map(p=>p.participants.find(v=>v!==u.id)).filter(Boolean))],m=new Map;await Promise.all(c.map(async p=>{let v=await s.getUserById(p);v&&m.set(p,v)}));let g=l.map(p=>{let v=p.participants.find(b=>b!==u.id),E=v?m.get(v):null;return{...p,otherUser:E?{id:E.id,userName:E.userName}:null}});return n.json({conversations:g},200)}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.post("/conversations",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let{targetUserId:l}=n.body;if(!l)return n.json({error:"Target user ID is required"},400);try{let{conversation:c,isNew:m}=await s.getOrCreateConversation(u.id,l),g=await s.getUserById(l);return n.json({conversation:{...c,otherUser:g?{id:g.id,userName:g.userName}:null},isNew:m},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.get("/conversations/:conversationId/messages",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.conversationId;try{let c=await s.getConversationById(l);if(!c)return n.json({error:"Conversation not found"},404);if(!c.participants.includes(u.id))return n.json({error:"You are not a participant in this conversation"},403);let m=n.query.limit?parseInt(n.query.limit,10):we,g=n.query.before||void 0,p=await s.getMessagesByConversation(l,{limit:m,before:g}),v=await y(p);return n.json({messages:v},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/conversations/:conversationId/messages",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.conversationId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let g=await s.createDirectMessage(c,u.id,l,m);return n.json({message:g},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.put("/conversations/:conversationId/messages/:messageId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId,c=n.body?.content,m=n.body?.images;if(!c&&!m)return n.json({error:"Message content is required"},400);try{let{message:g,removedImages:p}=await s.updateDirectMessage(l,u.id,c,m);return z(p),n.json({message:g},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.delete("/conversations/:conversationId/messages/:messageId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.messageId;try{let m=(await s.getMessageById(l))?.images||[];return await s.deleteDirectMessage(l,u.id),z(m),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/conversations/:conversationId/messages/image",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.conversationId;try{let c=await s.getConversationById(l);if(!c)return n.json({error:"Conversation not found"},404);if(!c.participants.includes(u.id))return n.json({error:"You are not a participant in this conversation"},403);let{filename:m,image:g,thumbnail:p}=n.body;if(!g)return n.json({error:"No image provided"},400);let v=m.split(".").pop();if(!v)return n.json({error:"Missing file extension"},400);if(!ve.includes(v))return n.json({error:"Unsupported file format"},400);let E=Buffer.from(g,"base64"),b=be*1024*1024;if(E.length>b)return n.json({error:"Image too large"},400);let S=`${process.cwd()}/uploads`;P(S)||ye(S);let T=`${Date.now()}-${te(16).toString("hex")}.${v}`,A=U(S,T);return re(A,E),p&&Ee(S,T,p),n.json({success:!0,filename:T})}catch(c){return console.error("Image upload error:",c),n.json({success:!1,error:c instanceof Error?c.message:"Upload failed"},500)}}),d.get("/conversations/:conversationId/messages/image/:filename",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.conversationId;try{let c=await s.getConversationById(l);if(!c)return n.json({error:"Conversation not found"},404);if(!c.participants.includes(u.id))return n.json({error:"You are not a participant in this conversation"},403);let{filename:m}=n.params;if(m.includes("..")||m.includes("/")||m.includes("\\"))return n.json({error:"Invalid filename"},400);let g=`${process.cwd()}/uploads`,p=n.query.size==="thumb",v=U(g,`thumb-${m}`),E=p&&P(v)?v:U(g,m);if(!E.startsWith(g))return n.json({error:"Invalid filename"},400);if(!P(E))return n.json({error:"Image not found"},404);let b=We(E),S=p&&P(v)?"jpg":m.split(".").pop()?.toLowerCase(),T="application/octet-stream";return S==="jpg"||S==="jpeg"?T="image/jpeg":S==="png"?T="image/png":S==="webp"?T="image/webp":S==="svg"&&(T="image/svg+xml"),n.binary(b,T)}catch(c){return n.json({success:!1,error:c instanceof Error?c.message:"Image fetch failed"},500)}}),d.post("/channels/:channelId/messages/image",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);try{let{filename:l,image:c,thumbnail:m}=n.body;if(!c)return n.json({error:"No image provided"},400);let g=l.split(".").pop();if(!g)return n.json({error:"Missing file extension"},400);if(!ve.includes(g))return n.json({error:"Unsupported file format"},400);let p=Buffer.from(c,"base64"),v=be*1024*1024;if(p.length>v)return n.json({error:"Image too large"},400);let E=`${process.cwd()}/uploads`;P(E)||ye(E);let b=`${Date.now()}-${te(16).toString("hex")}.${g}`,S=U(E,b);return re(S,p),m&&Ee(E,b,m),n.json({success:!0,filename:b})}catch(l){return console.error("Image upload error:",l),n.json({success:!1,error:l instanceof Error?l.message:"Upload failed"},500)}}),d.get("/channels/:channelId/messages/image/:filename",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);try{let{filename:l}=n.params;if(l.includes("..")||l.includes("/")||l.includes("\\"))return n.json({error:"Invalid filename"},400);let c=`${process.cwd()}/uploads`,m=n.query.size==="thumb",g=U(c,`thumb-${l}`),p=m&&P(g)?g:U(c,l);if(!p.startsWith(c))return n.json({error:"Invalid filename"},400);if(!P(p))return n.json({error:"Image not found"},404);let v=We(p),E=m&&P(g)?"jpg":l.split(".").pop()?.toLowerCase(),b="application/octet-stream";return E==="jpg"||E==="jpeg"?b="image/jpeg":E==="png"?b="image/png":E==="webp"?b="image/webp":E==="svg"&&(b="image/svg+xml"),n.binary(v,b)}catch(l){return n.json({success:!1,error:l instanceof Error?l.message:"Image fetch failed"},500)}}),d.get("/server/settings",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);try{let l=await s.getServerSettings();return n.json(l||{name:"MikroChat"},200)}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.put("/server/settings",f,async n=>{if(!n.state.user)return n.json({error:"Unauthorized"},401);let{name:l}=n.body;if(!l)return n.json({error:"Server name is required"},400);try{return await s.updateServerSettings({name:l}),n.json({name:l},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.get("/webhooks",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);try{let c=(await s.listWebhooks(u.id)).map(({token:m,...g})=>g);return n.json({webhooks:c},200)}catch(l){let c=l instanceof Error?l.message:"An error occurred";return n.json({error:c},400)}}),d.post("/webhooks",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let{name:l,channelId:c}=n.body;if(!l)return n.json({error:"Webhook name is required"},400);if(!c)return n.json({error:"Channel ID is required"},400);try{let m=await s.createWebhook(l,c,u.id);return n.json({webhook:m},200)}catch(m){let g=m instanceof Error?m.message:"An error occurred";return n.json({error:g},400)}}),d.delete("/webhooks/:webhookId",f,async n=>{let u=n.state.user;if(!u)return n.json({error:"Unauthorized"},401);let l=n.params.webhookId;try{return await s.deleteWebhook(l,u.id),n.json({success:!0},200)}catch(c){let m=c instanceof Error?c.message:"An error occurred";return n.json({error:m},400)}}),d.post("/webhooks/:webhookId/messages",async n=>{let u=n.params.webhookId,l=n.body?.content;if(!l)return n.json({error:"Message content is required"},400);let c=n.headers.authorization;if(!c||!c.startsWith("Bearer "))return n.json({error:"Webhook token is required"},401);let m=c.split(" ")[1];if(!m)return n.json({error:"Webhook token is required"},401);try{let g=await s.getWebhookByToken(m);if(!g)return n.json({error:"Invalid webhook token"},401);if(g.id!==u)return n.json({error:"Webhook token does not match webhook ID"},403);let p=await s.createWebhookMessage(l,g);return n.json({message:p},200)}catch(g){let p=g instanceof Error?g.message:"An error occurred";return n.json({error:p},400)}}),d.get("/events",async n=>{let u=null,l=n.query.token;if(l)try{let b=r.verify(l);u=await s.getUserByEmail(b.email||b.sub)}catch(b){console.error("SSE token validation error:",b)}if(!u&&n.headers.authorization?.startsWith("Bearer ")){let b=n.headers.authorization.substring(7);try{let S=r.verify(b);u=await s.getUserByEmail(S.email||S.sub)}catch(S){console.error("SSE header validation error:",S)}}if(!u)return console.log("SSE unauthorized access attempt"),{statusCode:401,body:{error:"Unauthorized"},headers:{"Content-Type":"application/json"}};let c=te(8).toString("hex");if(V.has(u.id)){let b=Date.now(),S=V.get(u.id),T=[];if(S.forEach(A=>{let k=O.get(A)||0;b-k>Gt&&T.push(A)}),T.forEach(A=>{S.delete(A),O.delete(A),console.log(`Cleaned up stale connection ${A} for user ${u.id}`)}),S.size>=Kt){let A=null,k=Number.POSITIVE_INFINITY;S.forEach(N=>{let K=O.get(N)||0;K<k&&(k=K,A=N)}),A&&(S.delete(A),O.delete(A),console.log(`Removed oldest connection ${A} for user ${u.id} to make room`))}}else V.set(u.id,new Set);let m=V.get(u.id);m.add(c),O.set(c,Date.now()),console.log(`SSE connection established for user ${u.id} (${c}). Total connections: ${m.size}`),n.res.writeHead(200,{"Content-Type":"text/event-stream","Cache-Control":"no-cache",Connection:"keep-alive","X-Accel-Buffering":"no"});let g=()=>{O.set(c,Date.now())},p=setInterval(()=>{if(!n.res.writable){clearInterval(p);return}g(),n.res.write(`: ping

`)},3e4);n.res.write(`:

`),n.res.write(`data: ${JSON.stringify({type:"CONNECTED",payload:{message:"SSE connection established",timestamp:new Date().toISOString(),userId:u.id,connectionId:c}})}

`),g();let v=s.subscribeToEvents(b=>{if(!n.res.writable){v();return}if(["NEW_DM_MESSAGE","UPDATE_DM_MESSAGE","DELETE_DM_MESSAGE"].includes(b.type)){let T=b.payload;if(T.participants&&!T.participants.includes(u.id))return}try{g(),n.res.write(`data: ${JSON.stringify(b)}

`)}catch(T){console.error("Error sending SSE event:",T),E()}}),E=()=>{let b=V.get(u.id);b&&(b.delete(c),O.delete(c),console.log(`Connection ${c} for user ${u.id} cleaned up. Remaining: ${b.size}`),b.size===0&&V.delete(u.id)),v(),clearInterval(p),n.res.writable&&n.res.end()};return n.req.on("close",E),n.req.on("error",b=>{console.error(`SSE connection error for user ${u.id}:`,b),E()}),n.res.on("error",b=>{console.error(`SSE response error for user ${u.id}:`,b),E()}),{statusCode:200,_handled:!0,body:null}});async function f(n,u){let l={error:"Unauthorized",message:"Authentication required"},c=n.headers.authorization;if(!c||!c.startsWith("Bearer "))return n.status(401).json(l);let m=c.split(" ")[1];if(!m)return n.status(401).json(l);let g=r.verify(m),p=await s.getUserByEmail(g.email||g.sub);return n.state.user=p,u()}d.start()}function Ee(t,e,r){try{let s=Buffer.from(r,"base64"),i=U(t,`thumb-${e}`);re(i,s)}catch(s){console.error("Failed to save thumbnail:",s)}}function z(t){let e=`${process.cwd()}/uploads`;for(let r of t){if(!r||r.includes("..")||r.includes("/")||r.includes("\\"))continue;let s=U(e,r),i=U(e,`thumb-${r}`);if(s.startsWith(e))try{P(s)&&Fe(s),P(i)&&Fe(i)}catch(a){console.error(`Failed to delete image ${r}:`,a)}}}import{createCipheriv as Jt,createDecipheriv as Yt,randomBytes as Xt,scryptSync as Zt}from"node:crypto";var Ke="aes-256-gcm",Qt=16,Ge=16,er=32,tr="mikrochat",se=class{inner;derivedKey;constructor(e,r){this.inner=e,this.derivedKey=Zt(r,tr,er)}async get(e){let r=await this.inner.get(e);if(r==null)return null;try{return this.decrypt(r)}catch{return console.warn(`Failed to decrypt value for key "${e}" \u2014 returning null`),null}}async set(e,r,s){let i=this.encrypt(r);await this.inner.set(e,i,s)}async delete(e){await this.inner.delete(e)}async list(e){let r=await this.inner.list(e),s=[];for(let i of r)try{s.push(this.decrypt(i))}catch{}return s}encrypt(e){let r=Xt(Qt),s=Jt(Ke,this.derivedKey,r,{authTagLength:Ge}),i=JSON.stringify(e),a=Buffer.concat([s.update(i,"utf8"),s.final()]),o=s.getAuthTag();return`${r.toString("base64")}:${o.toString("base64")}:${a.toString("base64")}`}decrypt(e){let[r,s,i]=e.split(":"),a=Buffer.from(r,"base64"),o=Buffer.from(s,"base64"),h=Buffer.from(i,"base64"),d=Yt(Ke,this.derivedKey,a,{authTagLength:Ge});d.setAuthTag(o);let y=Buffer.concat([d.update(h),d.final()]);return JSON.parse(y.toString("utf8"))}};var ne=class extends j{db;pikoDB;constructor(e,r){super(),this.pikoDB=e;let s=new Ce(e);this.db=r?new se(s,r):s}async start(){await this.pikoDB.start()}async close(){await this.pikoDB.close()}},Ce=class{db;constructor(e){this.db=e}getTable(e){return e.startsWith("message:")?"messages":e.startsWith("idx:")?"indexes":e.startsWith("user:")?"users":e.startsWith("channel:")?"channels":e.startsWith("conversation:")?"conversations":e.startsWith("webhook:")?"webhooks":e.startsWith("server:")?"settings":"misc"}async get(e){try{let r=await this.db.get(this.getTable(e),e);return r??null}catch(r){return console.error(`Error getting key ${e}:`,r),null}}async set(e,r,s){let i=s?Date.now()+s*1e3:0;await this.db.write(this.getTable(e),e,r,i)}async delete(e){await this.db.delete(this.getTable(e),e)}async list(e){try{return(await this.db.get(this.getTable(e))||[]).filter(i=>Array.isArray(i)&&typeof i[0]=="string"&&i[0].startsWith(e)).map(i=>i[1]).filter(i=>i!=null)}catch(r){return console.error(`Error listing with prefix ${e}:`,r),[]}}};var C=De(),Je={configFilePath:"mikrochat.config.json",args:process.argv,options:[{flag:"--jwtSecret",path:"auth.jwtSecret",defaultValue:C.auth.jwtSecret},{flag:"--magicLinkExpirySeconds",path:"auth.magicLinkExpirySeconds",defaultValue:C.auth.magicLinkExpirySeconds},{flag:"--jwtExpirySeconds",path:"auth.jwtExpirySeconds",defaultValue:C.auth.jwtExpirySeconds},{flag:"--refreshTokenExpirySeconds",path:"auth.refreshTokenExpirySeconds",defaultValue:C.auth.refreshTokenExpirySeconds},{flag:"--maxActiveSessions",path:"auth.maxActiveSessions",defaultValue:C.auth.maxActiveSessions},{flag:"--appUrl",path:"auth.appUrl",defaultValue:C.auth.appUrl},{flag:"--authMode",path:"auth.authMode",defaultValue:C.auth.authMode},{flag:"--isInviteRequired",path:"auth.isInviteRequired",isFlag:!0,defaultValue:C.auth.isInviteRequired},{flag:"--debug",path:"auth.debug",isFlag:!0,defaultValue:C.auth.debug},{flag:"--emailSubject",path:"email.emailSubject",defaultValue:"Your Secure Login Link"},{flag:"--emailHost",path:"email.host",defaultValue:C.email.host},{flag:"--emailUser",path:"email.user",defaultValue:C.email.user},{flag:"--emailPassword",path:"email.password",defaultValue:C.email.password},{flag:"--emailPort",path:"email.port",defaultValue:C.email.port},{flag:"--emailSecure",path:"email.secure",isFlag:!0,defaultValue:C.email.secure},{flag:"--emailMaxRetries",path:"email.maxRetries",defaultValue:C.email.maxRetries},{flag:"--debug",path:"email.debug",isFlag:!0,defaultValue:C.email.debug},{flag:"--db",path:"storage.databaseDirectory",defaultValue:C.storage.databaseDirectory},{flag:"--encryptionKey",path:"storage.encryptionKey",defaultValue:C.storage.encryptionKey},{flag:"--debug",path:"storage.debug",defaultValue:C.storage.debug},{flag:"--port",path:"server.port",defaultValue:C.server.port},{flag:"--host",path:"server.host",defaultValue:C.server.host},{flag:"--https",path:"server.useHttps",isFlag:!0,defaultValue:C.server.useHttps},{flag:"--http2",path:"server.useHttp2",isFlag:!0,defaultValue:C.server.useHttp2},{flag:"--cert",path:"server.sslCert",defaultValue:C.server.sslCert},{flag:"--key",path:"server.sslKey",defaultValue:C.server.sslKey},{flag:"--ca",path:"server.sslCa",defaultValue:C.server.sslCa},{flag:"--ratelimit",path:"server.rateLimit.enabled",defaultValue:C.server.rateLimit.enabled,isFlag:!0},{flag:"--rps",path:"server.rateLimit.requestsPerMinute",defaultValue:C.server.rateLimit.requestsPerMinute},{flag:"--allowed",path:"server.allowedDomains",defaultValue:C.server.allowedDomains,parser:D.array},{flag:"--debug",path:"server.debug",isFlag:!0,defaultValue:C.server.debug},{flag:"--initialUserId",path:"chat.initialUser.id",defaultValue:C.chat.initialUser.id},{flag:"--initialUserName",path:"chat.initialUser.userName",defaultValue:C.chat.initialUser.userName},{flag:"--initialUserEmail",path:"chat.initialUser.email",defaultValue:C.chat.initialUser.email},{flag:"--initialUserPassword",path:"chat.initialUser.password",defaultValue:C.chat.initialUser.password},{flag:"--messageRetentionDays",path:"chat.messageRetentionDays",defaultValue:C.chat.messageRetentionDays},{flag:"--maxMessagesPerChannel",path:"chat.maxMessagesPerChannel",defaultValue:C.chat.maxMessagesPerChannel}]};function Ye(t){return{...t,auth:{...t.auth,templates:{textVersion:(e,r)=>`
Sign in to MikroChat: ${e}
This link expires in ${r} minutes and can only be used once.
If you didn't request this, please ignore this email.
`,htmlVersion:(e,r)=>`
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sign in to MikroChat</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
  <div style="max-width: 600px; margin: 0 auto; padding: 2rem;">
    <h1 style="font-size: 1.5rem; font-weight: 600; margin: 0 0 1rem 0; color: #202020;">Sign in to MikroChat</h1>
    <p style="font-size: 0.9rem; line-height: 1.5; margin: 0 0 1.5rem 0; color: #646464;">Click the button below to sign in to your account.</p>
    <a href="${e}" style="display: inline-block; padding: 0.75rem 1.5rem; background-color: #3e63dd; color: #ffffff; text-decoration: none; border-radius: 6px; font-size: 0.9rem; font-weight: 500;">Sign in</a>
    <p style="font-size: 0.8rem; line-height: 1.5; margin: 1.5rem 0 0 0; color: #8d8d8d;">This link expires in ${r} minutes and can only be used once. If you didn't request this, please ignore this email.</p>
  </div>
</body>
</html>
`}}}}async function rr(){let t=sr(),e=Ye(t),r=new he(e.storage);await r.start();let s=new Pe(r),i=new ne(r,e.storage.encryptionKey||void 0),a=e.auth.authMode||"magic-link",o=!!e.email?.host,h=a==="magic-link"||o?new Ue(e.email):void 0,d=new Me(e,h,s),y=new $(e.chat,i);await qe({config:e.server,auth:d,chat:y,isInviteRequired:e.auth.isInviteRequired,hasEmailConfig:o,authMode:a,appUrl:e.auth.appUrl,oauth:e.oauth})}function sr(){let t=new L(Je).get();return t.auth.debug&&console.log("Using configuration:",t),t}rr();
