(() => {
  var o = class {
    password;
    salt;
    constructor(t, e = {}) {
      if (((this.password = t), e.salt))
        if (typeof e.salt == 'string') {
          const r = new TextEncoder();
          this.salt = r.encode(e.salt);
        } else this.salt = e.salt;
      else
        this.salt = new Uint8Array([
          21, 35, 190, 124, 99, 84, 23, 67, 128, 56, 33, 71, 190, 222, 37, 85
        ]);
    }
    async setItem(t, e) {
      try {
        const r = JSON.stringify(e),
          n = await this.encrypt(r);
        localStorage.setItem(t, n);
      } catch (r) {
        throw (
          (console.error('Failed to encrypt and store data:', r),
          new Error('Encryption failed'))
        );
      }
    }
    async getItem(t) {
      const e = localStorage.getItem(t);
      if (!e) return null;
      try {
        const r = await this.decrypt(e);
        return JSON.parse(r);
      } catch (r) {
        return console.error('Failed to decrypt data:', r), null;
      }
    }
    removeItem(t) {
      localStorage.removeItem(t);
    }
    clear() {
      localStorage.clear();
    }
    async generateKey() {
      const t = new TextEncoder().encode(this.password),
        e = await window.crypto.subtle.importKey(
          'raw',
          t,
          { name: 'PBKDF2' },
          !1,
          ['deriveBits', 'deriveKey']
        );
      return window.crypto.subtle.deriveKey(
        { name: 'PBKDF2', salt: this.salt, iterations: 1e5, hash: 'SHA-256' },
        e,
        { name: 'AES-GCM', length: 256 },
        !1,
        ['encrypt', 'decrypt']
      );
    }
    async encrypt(t) {
      const e = window.crypto.getRandomValues(new Uint8Array(12)),
        r = await this.generateKey(),
        n = new TextEncoder().encode(t),
        s = await window.crypto.subtle.encrypt(
          { name: 'AES-GCM', iv: e },
          r,
          n
        ),
        a = new Uint8Array(e.length + s.byteLength);
      return (
        a.set(e, 0),
        a.set(new Uint8Array(s), e.length),
        btoa(String.fromCharCode(...a))
      );
    }
    async decrypt(t) {
      const e = Uint8Array.from(atob(t), (i) => i.charCodeAt(0)),
        r = e.slice(0, 12),
        n = e.slice(12),
        s = await this.generateKey(),
        a = await window.crypto.subtle.decrypt(
          { name: 'AES-GCM', iv: r },
          s,
          n
        );
      return new TextDecoder().decode(a);
    }
  };
  window.MikroSafe = o;
})();
